/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.util;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.handlers.BaseCryptoHandler;
import com.hedera.node.app.service.token.impl.handlers.transfer.TransferExecutor;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import edu.umd.cs.findbugs.annotations.Nullable;

public class CryptoTransferValidationHelper {
    private CryptoTransferValidationHelper() {
        throw new IllegalStateException("Utility class");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void checkSender(AccountID senderId, NftTransfer nftTransfer, PreHandleContext meta, ReadableAccountStore accountStore) throws PreCheckException {
        Account senderAccount = accountStore.getAliasedAccountById(senderId);
        if (senderAccount == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        Key key = senderAccount.key();
        if (key == null || !KeyUtils.isValid((Key)key)) {
            if (!HapiUtils.isHollow((Account)senderAccount)) throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
            meta.requireSignatureForHollowAccount(senderAccount);
            return;
        } else {
            if (nftTransfer.isApproval()) return;
            meta.requireKey(key);
        }
    }

    public static void checkReceiver(AccountID receiverId, AccountID senderId, NftTransfer nftTransfer, PreHandleContext meta, ReadableTokenStore.TokenMetadata tokenMeta, @Nullable CryptoTransferTransactionBody op, ReadableAccountStore accountStore, TransferExecutor.OptionalKeyCheck receiverKeyCheck) throws PreCheckException {
        Account receiverAccount = accountStore.getAliasedAccountById(receiverId);
        if (receiverAccount == null) {
            if (!AliasUtils.isAlias((AccountID)receiverId)) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
            }
            return;
        }
        Key receiverKey = receiverAccount.key();
        if (BaseCryptoHandler.isStakingAccount(meta.configuration(), receiverAccount.accountId())) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_ACCOUNT_ID);
        }
        if (receiverAccount.receiverSigRequired()) {
            if (receiverKeyCheck == TransferExecutor.OptionalKeyCheck.RECEIVER_KEY_IS_OPTIONAL) {
                meta.optionalKey(receiverKey);
            } else {
                meta.requireKeyOrThrow(receiverKey, ResponseCodeEnum.INVALID_TRANSFER_ACCOUNT_ID);
            }
        } else if (tokenMeta.hasRoyaltyWithFallback()) {
            AccountID treasuryId;
            if (op == null) {
                throw new PreCheckException(ResponseCodeEnum.INVALID_TRANSACTION);
            }
            if (!(CryptoTransferValidationHelper.receivesFungibleValue(nftTransfer.senderAccountID(), op, accountStore) || (treasuryId = tokenMeta.treasuryAccountId()).equals((Object)senderId) || treasuryId.equals((Object)receiverId))) {
                meta.requireKeyOrThrow(receiverId, ResponseCodeEnum.INVALID_TREASURY_ACCOUNT_FOR_TOKEN);
            }
        }
    }

    private static boolean receivesFungibleValue(AccountID target, CryptoTransferTransactionBody op, ReadableAccountStore accountStore) {
        for (AccountAmount adjust : op.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
            Account unaliasedAccount = accountStore.getAliasedAccountById(adjust.accountIDOrElse(AccountID.DEFAULT));
            Account unaliasedTarget = accountStore.getAliasedAccountById(target);
            if (unaliasedAccount == null || adjust.amount() <= 0L || !unaliasedAccount.equals((Object)unaliasedTarget)) continue;
            return true;
        }
        for (TokenTransferList transfers : op.tokenTransfers()) {
            for (AccountAmount adjust : transfers.transfers()) {
                Account unaliasedAccount = accountStore.getAliasedAccountById(adjust.accountIDOrElse(AccountID.DEFAULT));
                Account unaliasedTarget = accountStore.getAliasedAccountById(target);
                if (unaliasedAccount == null || adjust.amount() <= 0L || !unaliasedAccount.equals((Object)unaliasedTarget)) continue;
                return true;
            }
        }
        return false;
    }
}

