/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.state;

import com.google.common.base.MoreObjects;
import com.hedera.node.app.hapi.fees.pricing.ResourceProvider;
import com.hedera.node.app.hapi.fees.pricing.UsableResource;
import com.hedera.node.app.hapi.fees.usage.BaseTransactionMeta;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hederahashgraph.api.proto.java.FeeComponents;
import com.hederahashgraph.api.proto.java.FeeData;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class UsageAccumulator {
    private static final long LONG_BASIC_TX_BODY_SIZE = 76L;
    private long numPayerKeys;
    private long bpt;
    private long bpr;
    private long sbpr;
    private long vpt;
    private long gas;
    private long rbs;
    private long sbs;
    private long networkRbs;

    public static UsageAccumulator fromGrpc(FeeData usage) {
        UsageAccumulator into = new UsageAccumulator();
        FeeComponents networkUsage = usage.getNetworkdata();
        into.setUniversalBpt(networkUsage.getBpt());
        into.setVpt(networkUsage.getVpt());
        into.setNetworkRbs(networkUsage.getRbh() * 3600L);
        FeeComponents nodeUsage = usage.getNodedata();
        into.setNumPayerKeys(nodeUsage.getVpt());
        into.setBpr(nodeUsage.getBpr());
        into.setSbpr(nodeUsage.getSbpr());
        FeeComponents serviceUsage = usage.getServicedata();
        into.setRbs(serviceUsage.getRbh() * 3600L);
        into.setSbs(serviceUsage.getSbh() * 3600L);
        return into;
    }

    public void resetForTransaction(BaseTransactionMeta baseMeta, SigUsage sigUsage) {
        int memoBytes = baseMeta.memoUtf8Bytes();
        int numTransfers = baseMeta.numExplicitTransfers();
        this.sbpr = 0L;
        this.sbs = 0L;
        this.gas = 0L;
        this.bpr = 4L;
        this.vpt = sigUsage.numSigs();
        this.bpt = 76L + (long)memoBytes + (long)sigUsage.sigsSize();
        this.rbs = 180L * (long)(132 + memoBytes + 32 * numTransfers);
        this.networkRbs = 6480L;
        this.numPayerKeys = sigUsage.numPayerKeys();
    }

    public void reset() {
        this.numPayerKeys = 0L;
        this.bpt = 0L;
        this.bpr = 0L;
        this.sbpr = 0L;
        this.vpt = 0L;
        this.gas = 0L;
        this.rbs = 0L;
        this.sbs = 0L;
        this.networkRbs = 0L;
    }

    public void addBpt(long amount) {
        this.bpt += amount;
    }

    public void addBpr(long amount) {
        this.bpr += amount;
    }

    public void addSbpr(long amount) {
        this.sbpr += amount;
    }

    public void addVpt(long amount) {
        this.vpt += amount;
    }

    public void addGas(long amount) {
        this.gas += amount;
    }

    public void addRbs(long amount) {
        this.rbs += amount;
    }

    public void addSbs(long amount) {
        this.sbs += amount;
    }

    public void addNetworkRbs(long amount) {
        this.networkRbs += amount;
    }

    public long getUniversalBpt() {
        return this.bpt;
    }

    public long getNetworkVpt() {
        return this.vpt;
    }

    public long getNetworkRbh() {
        return SingletonEstimatorUtils.ESTIMATOR_UTILS.nonDegenerateDiv(this.networkRbs, 3600);
    }

    public long getNodeBpr() {
        return this.bpr;
    }

    public long getNodeSbpr() {
        return this.sbpr;
    }

    public long getNodeVpt() {
        return this.numPayerKeys;
    }

    public long getServiceRbh() {
        return SingletonEstimatorUtils.ESTIMATOR_UTILS.nonDegenerateDiv(this.rbs, 3600);
    }

    public long getServiceSbh() {
        return SingletonEstimatorUtils.ESTIMATOR_UTILS.nonDegenerateDiv(this.sbs, 3600);
    }

    public long get(ResourceProvider provider, UsableResource resource) {
        switch (provider) {
            case NETWORK: {
                switch (resource) {
                    case BPT: {
                        return this.getUniversalBpt();
                    }
                    case VPT: {
                        return this.getNetworkVpt();
                    }
                    case RBH: {
                        return this.getNetworkRbh();
                    }
                    case CONSTANT: {
                        return 1L;
                    }
                }
                return 0L;
            }
            case NODE: {
                switch (resource) {
                    case BPT: {
                        return this.getUniversalBpt();
                    }
                    case BPR: {
                        return this.getNodeBpr();
                    }
                    case SBPR: {
                        return this.getNodeSbpr();
                    }
                    case VPT: {
                        return this.getNodeVpt();
                    }
                    case CONSTANT: {
                        return 1L;
                    }
                }
                return 0L;
            }
            case SERVICE: {
                switch (resource) {
                    case RBH: {
                        return this.getServiceRbh();
                    }
                    case SBH: {
                        return this.getServiceSbh();
                    }
                    case CONSTANT: {
                        return 1L;
                    }
                }
                return 0L;
            }
        }
        return 0L;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("universalBpt", this.getUniversalBpt()).add("networkVpt", this.getNetworkVpt()).add("networkRbh", this.getNetworkRbh()).add("nodeBpr", this.getNodeBpr()).add("nodeSbpr", this.getNodeSbpr()).add("nodeVpt", this.getNodeVpt()).add("serviceSbh", this.getServiceSbh()).add("serviceRbh", this.getServiceRbh()).add("gas", this.getGas()).add("rbs", this.getRbs()).toString();
    }

    long getBpt() {
        return this.bpt;
    }

    long getBpr() {
        return this.bpr;
    }

    long getSbpr() {
        return this.sbpr;
    }

    long getVpt() {
        return this.vpt;
    }

    long getGas() {
        return this.gas;
    }

    long getRbs() {
        return this.rbs;
    }

    long getSbs() {
        return this.sbs;
    }

    long getNetworkRbs() {
        return this.networkRbs;
    }

    long getNumPayerKeys() {
        return this.numPayerKeys;
    }

    public void setNumPayerKeys(long numPayerKeys) {
        this.numPayerKeys = numPayerKeys;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj, (String[])new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, (String[])new String[0]);
    }

    private void setUniversalBpt(long bpt) {
        this.bpt = bpt;
    }

    private void setBpr(long bpr) {
        this.bpr = bpr;
    }

    private void setSbpr(long sbpr) {
        this.sbpr = sbpr;
    }

    private void setVpt(long vpt) {
        this.vpt = vpt;
    }

    private void setRbs(long rbs) {
        this.rbs = rbs;
    }

    private void setSbs(long sbs) {
        this.sbs = sbs;
    }

    private void setNetworkRbs(long networkRbs) {
        this.networkRbs = networkRbs;
    }
}

