/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.ids.schemas;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.platform.state.SingletonType;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.pbj.runtime.Codec;
import com.swirlds.state.lifecycle.MigrationContext;
import com.swirlds.state.lifecycle.Schema;
import com.swirlds.state.lifecycle.StateDefinition;
import com.swirlds.state.lifecycle.StateMetadata;
import com.swirlds.state.spi.WritableSingletonState;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class V0490EntityIdSchema
extends Schema {
    private static final Logger log = LogManager.getLogger(V0490EntityIdSchema.class);
    private static final SemanticVersion VERSION = SemanticVersion.newBuilder().major(0).minor(49).patch(0).build();
    public static final String ENTITY_ID_KEY = "ENTITY_ID";
    public static final int ENTITY_ID_STATE_ID = SingletonType.ENTITYIDSERVICE_I_ENTITY_ID.protoOrdinal();
    public static final String ENTITY_ID_STATE_LABEL = StateMetadata.computeLabel((String)"EntityIdService", (String)"ENTITY_ID");

    public V0490EntityIdSchema() {
        super(VERSION);
    }

    @NonNull
    public Set<StateDefinition> statesToCreate() {
        return Set.of(StateDefinition.singleton((int)ENTITY_ID_STATE_ID, (String)ENTITY_ID_KEY, (Codec)EntityNumber.PROTOBUF));
    }

    public void migrate(@NonNull MigrationContext ctx) {
        WritableSingletonState entityIdState = ctx.newStates().getSingleton(ENTITY_ID_STATE_ID);
        if (entityIdState.get() == null) {
            HederaConfig config = (HederaConfig)ctx.appConfig().getConfigData(HederaConfig.class);
            long entityNum = config.firstUserEntity() - 1L;
            log.info("Setting initial entity id to {}", (Object)entityNum);
            entityIdState.put((Object)new EntityNumber(entityNum));
        }
    }
}

