/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.state.merkle;

import com.hedera.hapi.node.base.SemanticVersion;
import com.swirlds.state.lifecycle.HapiUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public class VersionUtils {
    private VersionUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static boolean isSameVersion(@Nullable SemanticVersion a, @Nullable SemanticVersion b) {
        return a == null && b == null || a != null && b != null && HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(a, b) == 0;
    }

    public static boolean alreadyIncludesStateDefs(@Nullable SemanticVersion stateVersion, @NonNull SemanticVersion schemaVersion) {
        Objects.requireNonNull(schemaVersion);
        if (stateVersion == null) {
            return false;
        }
        SemanticVersion coreStateVersion = stateVersion.copyBuilder().pre("").build("").build();
        return HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(coreStateVersion, schemaVersion) >= 0;
    }

    public static boolean isSoOrdered(@Nullable SemanticVersion maybeBefore, @Nullable SemanticVersion maybeAfter) {
        if (maybeAfter == null) {
            return false;
        }
        if (VersionUtils.isSameVersion(maybeBefore, maybeAfter)) {
            return false;
        }
        if (maybeBefore == null) {
            return true;
        }
        return HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(maybeBefore, maybeAfter) < 0;
    }
}

