/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tuweni.units.bigints;

import java.math.BigInteger;
import java.util.Objects;
import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt32;
import org.apache.tuweni.units.bigints.UInt32Value;

public abstract class BaseUInt32Value<T extends UInt32Value<T>>
implements UInt32Value<T> {
    private final UInt32 value;
    private final Function<UInt32, T> ctor;

    protected BaseUInt32Value(UInt32 value, Function<UInt32, T> ctor) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(ctor);
        this.value = value;
        this.ctor = ctor;
    }

    protected BaseUInt32Value(int value, Function<UInt32, T> ctor) {
        Objects.requireNonNull(ctor);
        this.value = UInt32.valueOf(value);
        this.ctor = ctor;
    }

    protected BaseUInt32Value(BigInteger value, Function<UInt32, T> ctor) {
        Objects.requireNonNull(value);
        Objects.requireNonNull(ctor);
        this.value = UInt32.valueOf(value);
        this.ctor = ctor;
    }

    protected T copy() {
        return (T)((UInt32Value)this.ctor.apply(this.value));
    }

    protected T zero() {
        return (T)((UInt32Value)this.ctor.apply(UInt32.ZERO));
    }

    @Override
    public T add(T value) {
        return this.add(value.toUInt32());
    }

    @Override
    public T add(UInt32 value) {
        if (value.isZero()) {
            return this.copy();
        }
        return (T)((UInt32Value)this.ctor.apply(this.value.add(value)));
    }

    @Override
    public T add(int value) {
        if (value == 0) {
            return this.copy();
        }
        return (T)((UInt32Value)this.ctor.apply(this.value.add(value)));
    }

    @Override
    public T addMod(T value, UInt32 modulus) {
        return this.addMod(value.toUInt32(), modulus);
    }

    @Override
    public T addMod(UInt32 value, UInt32 modulus) {
        return (T)((UInt32Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T addMod(long value, UInt32 modulus) {
        return (T)((UInt32Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T addMod(long value, long modulus) {
        return (T)((UInt32Value)this.ctor.apply(this.value.addMod(value, modulus)));
    }

    @Override
    public T subtract(T value) {
        return this.subtract(value.toUInt32());
    }

    @Override
    public T subtract(UInt32 value) {
        if (value.isZero()) {
            return this.copy();
        }
        return (T)((UInt32Value)this.ctor.apply(this.value.subtract(value)));
    }

    @Override
    public T subtract(int value) {
        if (value == 0) {
            return this.copy();
        }
        return (T)((UInt32Value)this.ctor.apply(this.value.subtract(value)));
    }

    @Override
    public T multiply(T value) {
        return this.multiply(value.toUInt32());
    }

    @Override
    public T multiply(UInt32 value) {
        if (this.isZero() || value.isZero()) {
            return this.zero();
        }
        if (value.equals(UInt32.ONE)) {
            return this.copy();
        }
        return (T)((UInt32Value)this.ctor.apply(this.value.multiply(value)));
    }

    @Override
    public T multiply(int value) {
        if (value == 0 || this.isZero()) {
            return this.zero();
        }
        if (value == 1) {
            return this.copy();
        }
        return (T)((UInt32Value)this.ctor.apply(this.value.multiply(value)));
    }

    @Override
    public T multiplyMod(T value, UInt32 modulus) {
        return this.multiplyMod(value.toUInt32(), modulus);
    }

    @Override
    public T multiplyMod(UInt32 value, UInt32 modulus) {
        return (T)((UInt32Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T multiplyMod(int value, UInt32 modulus) {
        return (T)((UInt32Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T multiplyMod(int value, int modulus) {
        return (T)((UInt32Value)this.ctor.apply(this.value.multiplyMod(value, modulus)));
    }

    @Override
    public T divide(T value) {
        return this.divide(value.toUInt32());
    }

    @Override
    public T divide(UInt32 value) {
        return (T)((UInt32Value)this.ctor.apply(this.value.divide(value)));
    }

    @Override
    public T divide(int value) {
        return (T)((UInt32Value)this.ctor.apply(this.value.divide(value)));
    }

    @Override
    public T pow(UInt32 exponent) {
        return (T)((UInt32Value)this.ctor.apply(this.value.pow(exponent)));
    }

    @Override
    public T pow(long exponent) {
        return (T)((UInt32Value)this.ctor.apply(this.value.pow(exponent)));
    }

    @Override
    public T mod(UInt32 modulus) {
        return (T)((UInt32Value)this.ctor.apply(this.value.mod(modulus)));
    }

    @Override
    public T mod(int modulus) {
        return (T)((UInt32Value)this.ctor.apply(this.value.mod(modulus)));
    }

    @Override
    public int compareTo(T other) {
        return this.compareTo(other.toUInt32());
    }

    @Override
    public int compareTo(UInt32 other) {
        return this.value.compareTo(other);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UInt32Value)) {
            return false;
        }
        UInt32Value other = (UInt32Value)obj;
        return this.value.equals(other.toUInt32());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.toString();
    }

    @Override
    public UInt32 toUInt32() {
        return this.value;
    }

    @Override
    public Bytes toBytes() {
        return this.value.toBytes();
    }

    @Override
    public Bytes toMinimalBytes() {
        return this.value.toMinimalBytes();
    }
}

