/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http1;

import io.helidon.builder.api.Prototype;
import io.helidon.http.RequestedUriDiscoveryContext;
import io.helidon.webserver.http1.Http1Config;
import io.helidon.webserver.http1.Http1ConnectionListener;
import io.helidon.webserver.http1.Http1LoggingConnectionListener;
import java.util.List;

class Http1BuilderDecorator
implements Prototype.BuilderDecorator<Http1Config.BuilderBase<?, ?>> {
    Http1BuilderDecorator() {
    }

    public void decorate(Http1Config.BuilderBase<?, ?> target) {
        this.receiveListeners(target);
        this.sentListeners(target);
        if (target.name().isEmpty()) {
            target.name("@default");
        }
        if (target.requestedUriDiscovery().isEmpty()) {
            target.requestedUriDiscovery(RequestedUriDiscoveryContext.builder().socketId(target.name().orElse("@default")).build());
        }
    }

    private void sentListeners(Http1Config.BuilderBase<?, ?> target) {
        List<Http1ConnectionListener> listeners = target.sendListeners();
        if (listeners.isEmpty() && target.sendLog()) {
            target.addSendListener(new Http1LoggingConnectionListener("send"));
        }
        listeners = target.sendListeners();
        target.compositeSendListener(Http1ConnectionListener.create(listeners));
    }

    private void receiveListeners(Http1Config.BuilderBase<?, ?> target) {
        List<Http1ConnectionListener> listeners = target.receiveListeners();
        if (listeners.isEmpty() && target.receiveLog()) {
            target.addReceiveListener(new Http1LoggingConnectionListener("recv"));
        }
        listeners = target.receiveListeners();
        target.compositeReceiveListener(Http1ConnectionListener.create(listeners));
    }
}

