/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.code.CodeInvalid;
import org.hyperledger.besu.evm.code.CodeV0;
import org.hyperledger.besu.evm.code.CodeV1;
import org.hyperledger.besu.evm.code.CodeV1Validation;
import org.hyperledger.besu.evm.code.EOFLayout;

public final class CodeFactory {
    public static final byte EOF_LEAD_BYTE = -17;

    private CodeFactory() {
    }

    public static Code createCode(Bytes bytes, int maxEofVersion, boolean inCreateOperation) {
        if (maxEofVersion == 0) {
            return new CodeV0(bytes);
        }
        if (maxEofVersion == 1) {
            int codeSize = bytes.size();
            if (codeSize > 0 && bytes.get(0) == -17) {
                if (codeSize == 1 && !inCreateOperation) {
                    return new CodeV0(bytes);
                }
                if (codeSize < 3) {
                    return new CodeInvalid(bytes, "EOF Container too short");
                }
                if (bytes.get(1) != 0) {
                    if (inCreateOperation) {
                        return new CodeInvalid(bytes, "Incorrect second byte");
                    }
                    return new CodeV0(bytes);
                }
                byte version = bytes.get(2);
                if (version != 1) {
                    return new CodeInvalid(bytes, "Unsupported EOF Version: " + version);
                }
                EOFLayout layout = EOFLayout.parseEOF(bytes);
                if (!layout.isValid()) {
                    return new CodeInvalid(bytes, "Invalid EOF Layout: " + layout.getInvalidReason());
                }
                String codeValidationError = CodeV1Validation.validateCode(layout);
                if (codeValidationError != null) {
                    return new CodeInvalid(bytes, "EOF Code Invalid : " + codeValidationError);
                }
                String stackValidationError = CodeV1Validation.validateStack(layout);
                if (stackValidationError != null) {
                    return new CodeInvalid(bytes, "EOF Code Invalid : " + stackValidationError);
                }
                return new CodeV1(layout);
            }
            return new CodeV0(bytes);
        }
        return new CodeInvalid(bytes, "Unsupported max code version " + maxEofVersion);
    }
}

