/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.grpc.helidon;

import com.hedera.pbj.grpc.helidon.PbjMethodRoute;
import com.hedera.pbj.grpc.helidon.PbjRoute;
import com.hedera.pbj.runtime.grpc.ServiceInterface;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.helidon.http.HttpPrologue;
import io.helidon.http.PathMatchers;
import java.util.List;
import java.util.Objects;

class PbjServiceRoute
extends PbjRoute {
    private final String serviceName;
    private final List<PbjMethodRoute> routes;

    PbjServiceRoute(@NonNull ServiceInterface service) {
        this.serviceName = Objects.requireNonNull(service).serviceName();
        this.routes = service.methods().stream().map(method -> new PbjMethodRoute(service, (ServiceInterface.Method)method)).toList();
    }

    @Override
    @NonNull
    PbjMethodRoute toPbjMethodRoute(@NonNull HttpPrologue prologue) {
        for (PbjMethodRoute route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return route;
        }
        throw new IllegalStateException("PbjServiceRoute(" + this.serviceName + ") accepted prologue, but cannot provide route: " + String.valueOf(prologue));
    }

    @Override
    @NonNull
    PathMatchers.MatchResult accepts(@NonNull HttpPrologue prologue) {
        for (PbjMethodRoute route : this.routes) {
            PathMatchers.MatchResult accepts = route.accepts(prologue);
            if (!accepts.accepted()) continue;
            return accepts;
        }
        return PathMatchers.MatchResult.notAccepted();
    }
}

