/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.transfer;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.LogBuilder;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class TransferEventLoggingUtils {
    private static final Bytes TRANSFER_EVENT = Bytes.fromHexString((CharSequence)"ddf252ad1be2c89b69c2b068fc378daa952ba7f163c4a11628f55a4df523b3ef");

    private TransferEventLoggingUtils() {
        throw new UnsupportedOperationException("Utility Class");
    }

    public static void logSuccessfulFungibleTransfer(@NonNull TokenID tokenId, @NonNull List<AccountAmount> adjusts, @NonNull ReadableAccountStore accountStore, @NonNull MessageFrame frame) {
        Objects.requireNonNull(tokenId);
        Objects.requireNonNull(frame);
        Objects.requireNonNull(adjusts);
        Objects.requireNonNull(accountStore);
        AccountAmount credit = adjusts.getFirst();
        if (credit.amount() < 0L) {
            throw new IllegalArgumentException("Credit adjustment must appear first");
        }
        frame.addLog(TransferEventLoggingUtils.builderFor(tokenId, adjusts.getLast().accountIDOrThrow(), credit.accountIDOrThrow(), accountStore).forDataItem(credit.amount()).build());
    }

    public static void logSuccessfulNftTransfer(@NonNull TokenID tokenId, @NonNull NftTransfer nftTransfer, @NonNull ReadableAccountStore accountStore, @NonNull MessageFrame frame) {
        Objects.requireNonNull(tokenId);
        Objects.requireNonNull(frame);
        Objects.requireNonNull(nftTransfer);
        Objects.requireNonNull(accountStore);
        frame.addLog(TransferEventLoggingUtils.builderFor(tokenId, nftTransfer.senderAccountIDOrThrow(), nftTransfer.receiverAccountIDOrThrow(), accountStore).forIndexedArgument(BigInteger.valueOf(nftTransfer.serialNumber())).build());
    }

    private static LogBuilder builderFor(@NonNull TokenID tokenId, @NonNull AccountID senderId, @NonNull AccountID receiverId, @NonNull ReadableAccountStore accountStore) {
        Address tokenAddress = ConversionUtils.asLongZeroAddress(tokenId.tokenNum());
        Address senderAddress = ConversionUtils.priorityAddressOf(Objects.requireNonNull(accountStore.getAliasedAccountById(senderId)));
        Address receiverAddress = ConversionUtils.priorityAddressOf(Objects.requireNonNull(accountStore.getAliasedAccountById(receiverId)));
        return LogBuilder.logBuilder().forLogger(tokenAddress).forEventSignature(TRANSFER_EVENT).forIndexedArgument(senderAddress).forIndexedArgument(receiverAddress);
    }
}

