/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.blocks.impl.streaming;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.time.Instant;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BlockNodeStats {
    private final Queue<Instant> endOfStreamTimestamps = new ConcurrentLinkedQueue<Instant>();

    public int getEndOfStreamCount() {
        return this.endOfStreamTimestamps.size();
    }

    public boolean addEndOfStreamAndCheckLimit(@NonNull Instant timestamp, int maxAllowed, @NonNull Duration timeFrame) {
        Instant endOfStreamTimestamp;
        Objects.requireNonNull(timestamp, "timestamp must not be null");
        Objects.requireNonNull(timeFrame, "timeFrame must not be null");
        this.endOfStreamTimestamps.add(timestamp);
        Instant now = Instant.now();
        Instant cutoff = now.minus(timeFrame);
        Iterator it = this.endOfStreamTimestamps.iterator();
        while (it.hasNext() && (endOfStreamTimestamp = (Instant)it.next()).isBefore(cutoff)) {
            it.remove();
        }
        return this.endOfStreamTimestamps.size() > maxAllowed;
    }
}

