/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hints;

import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.node.app.blocks.BlockHashSigner;
import com.hedera.node.app.hints.WritableHintsStore;
import com.hedera.node.app.hints.handlers.HintsHandlers;
import com.hedera.node.app.hints.impl.OnHintsFinished;
import com.hedera.node.app.roster.ActiveRosters;
import com.hedera.node.app.roster.RosterService;
import com.hedera.node.config.data.TssConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.lifecycle.SchemaRegistry;
import com.swirlds.state.lifecycle.Service;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.Objects;

public interface HintsService
extends Service,
BlockHashSigner {
    public static final String NAME = "HintsService";
    public static final int MIGRATION_ORDER = RosterService.MIGRATION_ORDER - 1;
    public static final Bytes DISABLED_HINTS_METADATA = Bytes.wrap((byte[])new byte[1288]);

    @NonNull
    public Bytes activeVerificationKeyOrThrow();

    public void initCurrentRoster(@NonNull Roster var1);

    public void onFinishedConstruction(@Nullable OnHintsFinished var1);

    public void manageRosterAdoption(@NonNull WritableHintsStore var1, @NonNull Roster var2, @NonNull Roster var3, @NonNull Bytes var4, boolean var5);

    public void reconcile(@NonNull ActiveRosters var1, @NonNull WritableHintsStore var2, @NonNull Instant var3, @NonNull TssConfig var4, boolean var5);

    public void executeCrsWork(@NonNull WritableHintsStore var1, @NonNull Instant var2, boolean var3);

    public void stop();

    public HintsHandlers handlers();

    default public int migrationOrder() {
        return MIGRATION_ORDER;
    }

    @NonNull
    default public String getServiceName() {
        return NAME;
    }

    public void registerSchemas(@NonNull SchemaRegistry var1);

    public static int partySizeForRoster(@NonNull Roster roster) {
        Objects.requireNonNull(roster);
        return HintsService.partySizeForRosterNodeCount(roster.rosterEntries().size());
    }

    public static int partySizeForRosterNodeCount(int numSigners) {
        int candidate = numSigners + 2;
        if ((candidate & candidate - 1) == 0) {
            return candidate;
        }
        return Integer.highestOneBit(candidate) << 1;
    }
}

