/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.account;

import java.util.Objects;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Hash;

public class AccountStorageEntry {
    private final UInt256 value;
    private final Optional<UInt256> key;
    private final Bytes32 keyHash;

    private AccountStorageEntry(UInt256 value, Bytes32 keyHash, Optional<UInt256> key) {
        this.key = key;
        this.keyHash = keyHash;
        this.value = value;
    }

    public static AccountStorageEntry create(UInt256 value, Bytes32 keyHash, UInt256 key) {
        return AccountStorageEntry.create(value, keyHash, Optional.ofNullable(key));
    }

    public static AccountStorageEntry create(UInt256 value, Bytes32 keyHash, Optional<UInt256> key) {
        return new AccountStorageEntry(value, keyHash, key);
    }

    public static AccountStorageEntry forKeyAndValue(UInt256 key, UInt256 value) {
        return AccountStorageEntry.create(value, (Bytes32)Hash.hash((Bytes)key), key);
    }

    public Optional<UInt256> getKey() {
        return this.key;
    }

    public Bytes32 getKeyHash() {
        return this.keyHash;
    }

    public UInt256 getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AccountStorageEntry)) {
            return false;
        }
        AccountStorageEntry that = (AccountStorageEntry)o;
        return Objects.equals(this.value, that.value) && Objects.equals(this.key, that.key) && Objects.equals(this.keyHash, that.keyHash);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.key, this.keyHash);
    }

    public String toString() {
        return "AccountStorageEntry{key=" + this.key + ", keyHash=" + this.keyHash + ", value=" + this.value + "}";
    }
}

