/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import io.helidon.common.media.type.MediaType;
import io.helidon.common.media.type.MediaTypes;
import io.helidon.common.media.type.ParserMode;
import io.helidon.http.HttpMediaTypeImpl;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Predicate;

public sealed interface HttpMediaType
extends Predicate<HttpMediaType>,
Comparable<HttpMediaType>,
MediaType
permits HttpMediaTypeImpl {
    public static final String CHARSET_PARAMETER = "charset";
    public static final String QUALITY_FACTOR_PARAMETER = "q";

    public static Builder builder() {
        return new Builder();
    }

    public static HttpMediaType create(MediaType mediaType) {
        return HttpMediaType.builder().mediaType(mediaType).build();
    }

    public static HttpMediaType create(String mediaTypeString) {
        return Builder.parse(mediaTypeString, ParserMode.STRICT);
    }

    public static HttpMediaType create(String mediaTypeString, ParserMode parserMode) {
        return Builder.parse(mediaTypeString, parserMode);
    }

    public MediaType mediaType();

    public double qualityFactor();

    public Map<String, String> parameters();

    default public Optional<String> charset() {
        return Optional.ofNullable(this.parameters().get(CHARSET_PARAMETER));
    }

    @Override
    public boolean test(HttpMediaType var1);

    @Override
    public boolean test(MediaType var1);

    default public String type() {
        return this.mediaType().type();
    }

    default public String subtype() {
        return this.mediaType().subtype();
    }

    default public HttpMediaType withCharset(String charset) {
        return HttpMediaType.builder().mediaType(this.mediaType()).parameters(this.parameters()).charset(charset).build();
    }

    default public HttpMediaType withCharset(Charset charset) {
        return this.withCharset(charset.name());
    }

    public String text();

    default public HttpMediaType withParameter(String name, String value) {
        return HttpMediaType.builder().mediaType(this.mediaType()).parameters(this.parameters()).addParameter(name, value).build();
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, HttpMediaType> {
        private final Map<String, String> parameters = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        private MediaType mediaType = MediaTypes.WILDCARD;

        private Builder() {
        }

        public HttpMediaType build() {
            return new HttpMediaTypeImpl(this);
        }

        public Builder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder charset(String charset) {
            this.parameters.put(HttpMediaType.CHARSET_PARAMETER, charset);
            return this;
        }

        public Builder addParameter(String parameter, String value) {
            this.parameters.put(parameter.toLowerCase(), value);
            return this;
        }

        public Builder parameters(Map<String, String> parameters) {
            this.parameters.clear();
            parameters.forEach((key, value) -> this.parameters.put(key.toLowerCase(), (String)value));
            return this;
        }

        public Builder q(double q) {
            this.addParameter(HttpMediaType.QUALITY_FACTOR_PARAMETER, String.valueOf(q));
            return this;
        }

        Map<String, String> parameters() {
            return this.parameters;
        }

        MediaType mediaType() {
            return this.mediaType;
        }

        private static HttpMediaType parse(String mediaTypeString, ParserMode parserMode) {
            Builder b = HttpMediaType.builder();
            int index = mediaTypeString.indexOf(59);
            if (index != -1) {
                String[] params;
                b.mediaType(MediaTypes.create((String)mediaTypeString.substring(0, index)));
                for (String param : params = mediaTypeString.substring(index + 1).split(";")) {
                    int eq = param.indexOf(61);
                    if (eq == -1) {
                        throw new IllegalArgumentException("Invalid media type, param does not contain =");
                    }
                    String value = param.substring(eq + 1).trim();
                    if (value.isEmpty()) continue;
                    if (value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    b.addParameter(param.substring(0, eq).trim(), value);
                }
            } else {
                b.mediaType(MediaTypes.create((String)mediaTypeString, (ParserMode)parserMode));
            }
            return b.build();
        }
    }
}

