/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.contractvalidation;

import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.Code;
import org.hyperledger.besu.evm.EvmSpecVersion;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.contractvalidation.ContractValidationRule;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;

public class CachedInvalidCodeRule
implements ContractValidationRule {
    private final int maxEofVersion;

    public CachedInvalidCodeRule(int maxEofVersion) {
        this.maxEofVersion = maxEofVersion;
    }

    @Override
    public Optional<ExceptionalHaltReason> validate(Bytes contractCode, MessageFrame frame) {
        Code code = CodeFactory.createCode(contractCode, this.maxEofVersion, false);
        if (!code.isValid()) {
            return Optional.of(ExceptionalHaltReason.INVALID_CODE);
        }
        return Optional.empty();
    }

    public static ContractValidationRule of(EvmSpecVersion specVersion) {
        return new CachedInvalidCodeRule(specVersion.getMaxEofVersion());
    }
}

