/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.gascalculator;

import java.util.function.Supplier;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.evm.gascalculator.PetersburgGasCalculator;

public class IstanbulGasCalculator
extends PetersburgGasCalculator {
    private static final long TX_DATA_ZERO_COST = 4L;
    private static final long ISTANBUL_TX_DATA_NON_ZERO_COST = 16L;
    private static final long TX_BASE_COST = 21000L;
    private static final long SLOAD_GAS = 800L;
    private static final long BALANCE_OPERATION_GAS_COST = 700L;
    private static final long EXTCODE_HASH_COST = 700L;
    private static final long SSTORE_SET_GAS = 20000L;
    private static final long SSTORE_RESET_GAS = 5000L;
    private static final long SSTORE_CLEARS_SCHEDULE = 15000L;
    private static final long SSTORE_SET_GAS_LESS_SLOAD_GAS = 19200L;
    private static final long SSTORE_RESET_GAS_LESS_SLOAD_GAS = 4200L;
    private static final long NEGATIVE_SSTORE_CLEARS_SCHEDULE = -15000L;

    @Override
    public long transactionIntrinsicGasCost(Bytes payload, boolean isContractCreation) {
        int zeros = 0;
        for (int i = 0; i < payload.size(); ++i) {
            if (payload.get(i) != 0) continue;
            ++zeros;
        }
        int nonZeros = payload.size() - zeros;
        long cost = 21000L + 4L * (long)zeros + 16L * (long)nonZeros;
        return isContractCreation ? cost + this.txCreateExtraGasCost() : cost;
    }

    @Override
    public long calculateStorageCost(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        UInt256 localCurrentValue = currentValue.get();
        if (localCurrentValue.equals((Object)newValue)) {
            return 800L;
        }
        UInt256 localOriginalValue = originalValue.get();
        if (localOriginalValue.equals((Object)localCurrentValue)) {
            return localOriginalValue.isZero() ? 20000L : 5000L;
        }
        return 800L;
    }

    @Override
    public long calculateStorageRefundAmount(UInt256 newValue, Supplier<UInt256> currentValue, Supplier<UInt256> originalValue) {
        UInt256 localCurrentValue = currentValue.get();
        if (localCurrentValue.equals((Object)newValue)) {
            return 0L;
        }
        UInt256 localOriginalValue = originalValue.get();
        if (localOriginalValue.equals((Object)localCurrentValue)) {
            if (localOriginalValue.isZero()) {
                return 0L;
            }
            if (newValue.isZero()) {
                return 15000L;
            }
            return 0L;
        }
        long refund = 0L;
        if (!localOriginalValue.isZero()) {
            if (localCurrentValue.isZero()) {
                refund = -15000L;
            } else if (newValue.isZero()) {
                refund = 15000L;
            }
        }
        if (localOriginalValue.equals((Object)newValue)) {
            refund += localOriginalValue.isZero() ? 19200L : 4200L;
        }
        return refund;
    }

    @Override
    public long getSloadOperationGasCost() {
        return 800L;
    }

    @Override
    public long getBalanceOperationGasCost() {
        return 700L;
    }

    @Override
    public long extCodeHashOperationGasCost() {
        return 700L;
    }

    @Override
    public long getMaximumTransactionCost(int size) {
        return 21000L + 16L * (long)size;
    }
}

