/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.log;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.ethereum.rlp.RLPInput;
import org.hyperledger.besu.ethereum.rlp.RLPOutput;
import org.hyperledger.besu.evm.log.LogTopic;

public class Log {
    private final Address logger;
    private final Bytes data;
    private final ImmutableList<LogTopic> topics;

    @JsonCreator
    public Log(@JsonProperty(value="logger") Address logger, @JsonProperty(value="data") Bytes data, @JsonProperty(value="topics") List<LogTopic> topics) {
        this.logger = logger;
        this.data = data;
        this.topics = ImmutableList.copyOf(topics);
    }

    public void writeTo(RLPOutput out) {
        out.startList();
        out.writeBytes((Bytes)this.logger);
        out.writeList(this.topics, (topic, listOut) -> listOut.writeBytes((Bytes)topic));
        out.writeBytes(this.data);
        out.endList();
    }

    public static Log readFrom(RLPInput in) {
        in.enterList();
        Address logger = Address.wrap((Bytes)in.readBytes());
        List topics = in.readList(listIn -> LogTopic.wrap((Bytes)listIn.readBytes32()));
        Bytes data = in.readBytes();
        in.leaveList();
        return new Log(logger, data, topics);
    }

    @JsonProperty(value="logger")
    public Address getLogger() {
        return this.logger;
    }

    @JsonProperty(value="data")
    public Bytes getData() {
        return this.data;
    }

    @JsonProperty(value="topics")
    public List<LogTopic> getTopics() {
        return this.topics;
    }

    public boolean equals(Object other) {
        if (!(other instanceof Log)) {
            return false;
        }
        Log that = (Log)other;
        return this.data.equals(that.data) && this.logger.equals((Object)that.logger) && this.topics.equals(that.topics);
    }

    public int hashCode() {
        return Objects.hash(this.data, this.logger, this.topics);
    }

    public String toString() {
        String joinedTopics = Joiner.on((String)"\n").join(this.topics);
        return String.format("Data: %s\nLogger: %s\nTopics: %s", this.data, this.logger, joinedTopics);
    }
}

