/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import java.util.function.Function;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.BlockValues;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class BlockHashOperation
extends AbstractFixedCostOperation {
    private static final int MAX_RELATIVE_BLOCK = 255;

    public BlockHashOperation(GasCalculator gasCalculator) {
        super(64, "BLOCKHASH", 1, 1, gasCalculator, gasCalculator.getBlockHashOperationGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Bytes blockArg = frame.popStackItem().trimLeadingZeros();
        if (blockArg.size() > 8) {
            frame.pushStackItem((Bytes)UInt256.ZERO);
            return this.successResponse;
        }
        long soughtBlock = blockArg.toLong();
        BlockValues blockValues = frame.getBlockValues();
        long currentBlockNumber = blockValues.getNumber();
        long mostRecentBlockNumber = currentBlockNumber - 1L;
        if (currentBlockNumber == 0L || soughtBlock < mostRecentBlockNumber - 255L || soughtBlock > mostRecentBlockNumber) {
            frame.pushStackItem((Bytes)Bytes32.ZERO);
        } else {
            Function<Long, Hash> blockHashLookup = frame.getBlockHashLookup();
            Hash blockHash = blockHashLookup.apply(soughtBlock);
            frame.pushStackItem((Bytes)blockHash);
        }
        return this.successResponse;
    }
}

