/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.MutableBytes;
import org.hyperledger.besu.crypto.Hash;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.operation.AbstractCreateOperation;

public class Create2Operation
extends AbstractCreateOperation {
    private static final Bytes PREFIX = Bytes.fromHexString((CharSequence)"0xFF");

    public Create2Operation(GasCalculator gasCalculator, int maxInitcodeSize) {
        super(245, "CREATE2", 4, 1, gasCalculator, maxInitcodeSize);
    }

    @Override
    public Address targetContractAddress(MessageFrame frame) {
        Address sender = frame.getRecipientAddress();
        long offset = Words.clampedToLong(frame.getStackItem(1));
        long length = Words.clampedToLong(frame.getStackItem(2));
        Bytes32 salt = Bytes32.leftPad((Bytes)frame.getStackItem(3));
        MutableBytes initCode = frame.readMutableMemory(offset, length);
        Bytes32 hash = Hash.keccak256((Bytes)Bytes.concatenate((Bytes[])new Bytes[]{PREFIX, sender, salt, Hash.keccak256((Bytes)initCode)}));
        Address address = Address.extract((Bytes32)hash);
        frame.warmUpAddress(address);
        return address;
    }

    @Override
    public long cost(MessageFrame frame) {
        return this.gasCalculator().create2OperationGasCost(frame);
    }
}

