/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.precompile;

import com.sun.jna.ptr.IntByReference;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;
import org.hyperledger.besu.nativelib.bls12_381.LibEthPairings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBLS12PrecompiledContract
implements PrecompiledContract {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractBLS12PrecompiledContract.class);
    static final int[] DISCOUNT_TABLE = new int[]{-1, 1200, 888, 764, 641, 594, 547, 500, 453, 438, 423, 408, 394, 379, 364, 349, 334, 330, 326, 322, 318, 314, 310, 306, 302, 298, 294, 289, 285, 281, 277, 273, 269, 268, 266, 265, 263, 262, 260, 259, 257, 256, 254, 253, 251, 250, 248, 247, 245, 244, 242, 241, 239, 238, 236, 235, 233, 232, 231, 229, 228, 226, 225, 223, 222, 221, 220, 219, 219, 218, 217, 216, 216, 215, 214, 213, 213, 212, 211, 211, 210, 209, 208, 208, 207, 206, 205, 205, 204, 203, 202, 202, 201, 200, 199, 199, 198, 197, 196, 196, 195, 194, 193, 193, 192, 191, 191, 190, 189, 188, 188, 187, 186, 185, 185, 184, 183, 182, 182, 181, 180, 179, 179, 178, 177, 176, 176, 175, 174};
    static final int MAX_DISCOUNT = 174;
    private final String name;
    private final byte operationId;
    private final int inputLen;

    AbstractBLS12PrecompiledContract(String name, byte operationId, int inputLen) {
        this.name = name;
        this.operationId = operationId;
        this.inputLen = inputLen + 1;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public PrecompiledContract.PrecompileContractResult computePrecompile(Bytes input, @Nonnull MessageFrame messageFrame) {
        byte[] result = new byte[256];
        byte[] error = new byte[256];
        IntByReference o_len = new IntByReference(256);
        IntByReference err_len = new IntByReference(256);
        int inputSize = Math.min(this.inputLen, input.size());
        int errorNo = LibEthPairings.eip2537_perform_operation((byte)this.operationId, (byte[])input.slice(0, inputSize).toArrayUnsafe(), (int)inputSize, (byte[])result, (IntByReference)o_len, (byte[])error, (IntByReference)err_len);
        if (errorNo == 0) {
            return PrecompiledContract.PrecompileContractResult.success(Bytes.wrap((byte[])result, (int)0, (int)o_len.getValue()));
        }
        String errorMessage = new String(error, 0, err_len.getValue(), StandardCharsets.UTF_8);
        messageFrame.setRevertReason(Bytes.wrap((byte[])error, (int)0, (int)err_len.getValue()));
        LOG.trace("Error executing precompiled contract {}: '{}'", (Object)this.name, (Object)errorMessage);
        return PrecompiledContract.PrecompileContractResult.halt(null, Optional.of(ExceptionalHaltReason.PRECOMPILE_ERROR));
    }

    protected int getDiscount(int k) {
        if (k >= DISCOUNT_TABLE.length) {
            return 174;
        }
        return DISCOUNT_TABLE[k];
    }
}

