/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public interface ReadableAccountStore {
    @Nullable
    public Account getAccountById(@NonNull AccountID var1);

    @Nullable
    public Account getAliasedAccountById(@NonNull AccountID var1);

    @Nullable
    public AccountID getAccountIDByAlias(long var1, long var3, @NonNull Bytes var5);

    public boolean containsAlias(long var1, long var3, @NonNull Bytes var5);

    public boolean contains(@NonNull AccountID var1);

    default public boolean isMissing(@NonNull AccountID accountID) {
        return this.getAliasedAccountById(accountID) == null;
    }

    public long getNumberOfAccounts();

    @Nullable
    default public Account getContractById(@NonNull ContractID contractID) {
        AccountID.Builder builder = AccountID.newBuilder().shardNum(contractID.shardNum()).realmNum(contractID.realmNum());
        if (contractID.hasEvmAddress()) {
            builder.alias(contractID.evmAddressOrThrow());
        } else {
            builder.accountNum(contractID.contractNumOrElse(Long.valueOf(0L)).longValue());
        }
        Account account = this.getAliasedAccountById(builder.build());
        return account == null || !account.smartContract() ? null : account;
    }

    public long sizeOfAccountState();

    default public void warm(@NonNull AccountID accountID) {
    }
}

