/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.Key;
import com.hedera.node.app.spi.workflows.HandleContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.function.Predicate;

public interface VerificationStrategy {
    public Decision decideForPrimitive(@NonNull Key var1);

    default public Predicate<Key> asSignatureTestIn(@NonNull HandleContext context, @Nullable Key maybeEthSenderKey) {
        Objects.requireNonNull(context);
        Predicate<Key> callback = this.asPrimitiveSignatureTestIn(context, maybeEthSenderKey);
        return key -> context.keyVerifier().verificationFor(key, (k, v) -> callback.test((Key)k)).passed();
    }

    default public Predicate<Key> asPrimitiveSignatureTestIn(@NonNull HandleContext context, @Nullable Key maybeEthSenderKey) {
        Objects.requireNonNull(context);
        return key -> {
            Objects.requireNonNull(key);
            return switch (this.decideForPrimitive((Key)key).ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> false;
                case 2 -> Objects.equals(key, maybeEthSenderKey) || context.keyVerifier().verificationFor(key).passed();
            };
        };
    }

    public static enum Decision {
        VALID,
        INVALID,
        DELEGATE_TO_CRYPTOGRAPHIC_VERIFICATION;

    }
}

