/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers.staking;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.impl.WritableStakingInfoStore;
import com.hedera.node.app.service.token.impl.handlers.staking.StakeRewardCalculatorImpl;
import com.hedera.node.app.service.token.impl.handlers.staking.StakingRewardsHelper;
import com.hedera.node.app.spi.workflows.record.DeleteCapableTransactionStreamBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
public class StakingRewardsDistributor {
    private static final Logger log = LogManager.getLogger(StakingRewardsDistributor.class);
    private StakingRewardsHelper stakingRewardHelper;
    private StakeRewardCalculatorImpl rewardCalculator;

    @Inject
    public StakingRewardsDistributor(@NonNull StakingRewardsHelper stakingRewardHelper, @NonNull StakeRewardCalculatorImpl rewardCalculator) {
        this.stakingRewardHelper = stakingRewardHelper;
        this.rewardCalculator = rewardCalculator;
    }

    public Map<AccountID, Long> payRewardsIfPending(@NonNull Set<AccountID> possibleRewardReceivers, @NonNull AccountID fundingAccountId, @NonNull WritableAccountStore writableStore, @NonNull WritableNetworkStakingRewardsStore stakingRewardsStore, @NonNull WritableStakingInfoStore stakingInfoStore, @NonNull Instant consensusNow, @NonNull DeleteCapableTransactionStreamBuilder recordBuilder) {
        Objects.requireNonNull(possibleRewardReceivers);
        HashMap<AccountID, Long> rewardsPaid = new HashMap<AccountID, Long>();
        long payableRewards = -1L;
        for (AccountID receiver : possibleRewardReceivers) {
            long finalReward;
            Account originalAccount = writableStore.getOriginalValue(receiver);
            if (originalAccount == null) continue;
            Account modifiedAccount = writableStore.get(receiver);
            long reward = this.rewardCalculator.computePendingReward(originalAccount, stakingInfoStore, stakingRewardsStore, consensusNow);
            AccountID receiverId = receiver;
            Account beneficiary = originalAccount;
            if (reward > 0L) {
                if (payableRewards == -1L) {
                    payableRewards = Objects.requireNonNull(writableStore.get(fundingAccountId)).tinybarBalance();
                }
                if ((reward = Math.min(reward, payableRewards)) > 0L) {
                    this.stakingRewardHelper.decreasePendingRewardsBy(stakingInfoStore, stakingRewardsStore, reward, originalAccount.stakedNodeIdOrThrow());
                    if (modifiedAccount.deleted()) {
                        int maxRedirects = recordBuilder.getNumberOfDeletedAccounts();
                        int curRedirects = 1;
                        do {
                            if (curRedirects++ <= maxRedirects) continue;
                            log.error("With {} accounts deleted, last redirect in modifications led to deleted beneficiary {}", (Object)maxRedirects, (Object)receiverId);
                            throw new IllegalStateException("Had to redirect reward to a deleted beneficiary");
                        } while ((beneficiary = writableStore.getOriginalValue(receiverId = recordBuilder.getDeletedAccountBeneficiaryFor(receiverId))).deleted());
                    }
                }
            }
            Account mutableBeneficiary = writableStore.get(beneficiary.accountId());
            long l = finalReward = beneficiary.declineReward() ? 0L : reward;
            if (finalReward > 0L) {
                this.applyReward(finalReward, mutableBeneficiary, writableStore);
                payableRewards -= finalReward;
            }
            rewardsPaid.merge(receiverId, finalReward, Long::sum);
        }
        return rewardsPaid;
    }

    private void applyReward(long reward, Account receiver, WritableAccountStore writableStore) {
        long finalBalance = receiver.tinybarBalance() + reward;
        Account.Builder copy = receiver.copyBuilder();
        copy.tinybarBalance(finalBalance);
        writableStore.put(copy.build());
    }
}

