/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.DelegatingBytes;
import org.hyperledger.besu.crypto.SECPPublicKey;
import org.hyperledger.besu.datatypes.Hash;
import org.hyperledger.besu.ethereum.rlp.RLP;
import org.hyperledger.besu.ethereum.rlp.RLPException;
import org.hyperledger.besu.ethereum.rlp.RLPInput;

public class Address
extends DelegatingBytes {
    public static final int SIZE = 20;
    public static final Address ECREC = Address.precompiled(1);
    public static final Address SHA256 = Address.precompiled(2);
    public static final Address RIPEMD160 = Address.precompiled(3);
    public static final Address ID = Address.precompiled(4);
    public static final Address MODEXP = Address.precompiled(5);
    public static final Address ALTBN128_ADD = Address.precompiled(6);
    public static final Address ALTBN128_MUL = Address.precompiled(7);
    public static final Address ALTBN128_PAIRING = Address.precompiled(8);
    public static final Address BLAKE2B_F_COMPRESSION = Address.precompiled(9);
    public static final Address KZG_POINT_EVAL = Address.precompiled(10);
    public static final Address BLS12_G1ADD = Address.precompiled(11);
    public static final Address BLS12_G1MUL = Address.precompiled(12);
    public static final Address BLS12_G1MULTIEXP = Address.precompiled(13);
    public static final Address BLS12_G2ADD = Address.precompiled(14);
    public static final Address BLS12_G2MUL = Address.precompiled(15);
    public static final Address BLS12_G2MULTIEXP = Address.precompiled(16);
    public static final Address BLS12_PAIRING = Address.precompiled(17);
    public static final Address BLS12_MAP_FP_TO_G1 = Address.precompiled(18);
    public static final Address BLS12_MAP_FP2_TO_G2 = Address.precompiled(19);
    public static final Address ZERO = Address.fromHexString("0x0");
    static LoadingCache<Address, Hash> hashCache = CacheBuilder.newBuilder().maximumSize(4000L).build((CacheLoader)new CacheLoader<Address, Hash>(){

        public Hash load(Address key) {
            return Hash.hash((Bytes)key);
        }
    });

    protected Address(Bytes bytes) {
        super(bytes);
    }

    public static Address wrap(Bytes value) {
        Preconditions.checkArgument((value.size() == 20 ? 1 : 0) != 0, (String)"An account address must be %s bytes long, got %s", (int)20, (int)value.size());
        if (value instanceof Address) {
            Address address = (Address)value;
            return address;
        }
        if (value instanceof DelegatingBytes) {
            DelegatingBytes delegatingBytes = (DelegatingBytes)value;
            return new Address(delegatingBytes.copy());
        }
        return new Address(value);
    }

    public static Address readFrom(RLPInput input) {
        Bytes bytes = input.readBytes();
        if (bytes.size() != 20) {
            throw new RLPException(String.format("Address unexpected size of %s (needs %s)", bytes.size(), 20));
        }
        return Address.wrap(bytes);
    }

    public static Address extract(Bytes32 hash) {
        return Address.wrap(hash.slice(12, 20));
    }

    public static Address extract(SECPPublicKey publicKey) {
        return Address.extract(org.hyperledger.besu.crypto.Hash.keccak256((Bytes)publicKey.getEncodedBytes()));
    }

    @JsonCreator
    public static Address fromHexString(String str) {
        if (str == null) {
            return null;
        }
        return Address.wrap(Bytes.fromHexStringLenient((CharSequence)str, (int)20));
    }

    public static Address fromHexStringStrict(String str) {
        Preconditions.checkArgument((str != null ? 1 : 0) != 0);
        Bytes value = Bytes.fromHexString((CharSequence)str);
        Preconditions.checkArgument((value.size() == 20 ? 1 : 0) != 0, (String)"An account address must be be %s bytes long, got %s", (int)20, (int)value.size());
        return new Address(value);
    }

    public static Address precompiled(int value) {
        Preconditions.checkArgument((value < 127 ? 1 : 0) != 0);
        byte[] address = new byte[20];
        address[19] = (byte)value;
        return new Address(Bytes.wrap((byte[])address));
    }

    public static Address privacyPrecompiled(int value) {
        return Address.precompiled(value);
    }

    public static Address contractAddress(Address senderAddress, long nonce) {
        return Address.extract(org.hyperledger.besu.crypto.Hash.keccak256((Bytes)RLP.encode(out -> {
            out.startList();
            out.writeBytes((Bytes)senderAddress);
            out.writeLongScalar(nonce);
            out.endList();
        })));
    }

    public static Address privateContractAddress(Address senderAddress, long nonce, Bytes privacyGroupId) {
        return Address.extract(org.hyperledger.besu.crypto.Hash.keccak256((Bytes)RLP.encode(out -> {
            out.startList();
            out.writeBytes((Bytes)senderAddress);
            out.writeLongScalar(nonce);
            out.writeBytes(privacyGroupId);
            out.endList();
        })));
    }

    public Hash addressHash() {
        try {
            return (Hash)((Object)hashCache.get((Object)this));
        }
        catch (ExecutionException e) {
            return Hash.hash((Bytes)this);
        }
    }
}

