/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.util.impl.handlers;

import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.node.util.AtomicBatchTransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.service.util.impl.cache.InnerTxnCache;
import com.hedera.node.app.service.util.impl.cache.TransactionParser;
import com.hedera.node.app.service.util.impl.records.ReplayableFeeStreamBuilder;
import com.hedera.node.app.spi.AppContext;
import com.hedera.node.app.spi.fees.FeeCalculator;
import com.hedera.node.app.spi.fees.FeeCharging;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.DispatchOptions;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.AtomicBatchConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AtomicBatchHandler
implements TransactionHandler {
    private final Supplier<FeeCharging> appFeeCharging;
    private final InnerTxnCache innerTxnCache;
    private static final Set<TransactionBody.DataOneOfType> CONTRACT_OP_BODIES = EnumSet.of(TransactionBody.DataOneOfType.CONTRACT_CALL, TransactionBody.DataOneOfType.CONTRACT_CREATE_INSTANCE, TransactionBody.DataOneOfType.ETHEREUM_TRANSACTION);
    private static final AccountID ATOMIC_BATCH_NODE_ACCOUNT_ID = AccountID.newBuilder().accountNum(0L).shardNum(0L).realmNum(0L).build();

    @Inject
    public AtomicBatchHandler(@NonNull AppContext appContext, @NonNull TransactionParser transactionParser) {
        Objects.requireNonNull(appContext);
        Objects.requireNonNull(transactionParser);
        this.appFeeCharging = appContext.feeChargingSupplier();
        this.innerTxnCache = new InnerTxnCache(transactionParser, (Configuration)appContext.configSupplier().get());
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        List innerTxs = context.body().atomicBatchOrThrow().transactions();
        if (innerTxs.isEmpty()) {
            throw new PreCheckException(ResponseCodeEnum.BATCH_LIST_EMPTY);
        }
        HashSet<TransactionID> txIds = new HashSet<TransactionID>();
        for (Bytes innerTxBytes : innerTxs) {
            TransactionBody txBody = this.innerTxnCache.computeIfAbsent(innerTxBytes);
            PreCheckException.validateTruePreCheck((boolean)txIds.add(txBody.transactionID()), (ResponseCodeEnum)ResponseCodeEnum.BATCH_LIST_CONTAINS_DUPLICATES);
            PreCheckException.validateTruePreCheck((boolean)txBody.hasBatchKey(), (ResponseCodeEnum)ResponseCodeEnum.MISSING_BATCH_KEY);
            if (txBody.hasNodeAccountID() && txBody.nodeAccountIDOrThrow().equals((Object)ATOMIC_BATCH_NODE_ACCOUNT_ID)) continue;
            throw new PreCheckException(ResponseCodeEnum.INVALID_NODE_ACCOUNT_ID);
        }
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        AtomicBatchTransactionBody atomicBatchTransactionBody = context.body().atomicBatchOrThrow();
        Configuration config = context.configuration();
        AtomicBatchConfig atomicBatchConfig = (AtomicBatchConfig)config.getConfigData(AtomicBatchConfig.class);
        List txns = atomicBatchTransactionBody.transactions();
        for (Bytes txnBytes : txns) {
            TransactionBody innerTxBody = this.innerTxnCache.computeIfAbsent(txnBytes);
            PreCheckException.validateFalsePreCheck((boolean)this.isNotAllowedFunction(innerTxBody, atomicBatchConfig), (ResponseCodeEnum)ResponseCodeEnum.BATCH_TRANSACTION_IN_BLACKLIST);
            context.requireKeyOrThrow(innerTxBody.batchKey(), ResponseCodeEnum.INVALID_BATCH_KEY);
        }
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        Objects.requireNonNull(context);
        AtomicBatchTransactionBody op = context.body().atomicBatchOrThrow();
        HandleException.validateTrue((boolean)((AtomicBatchConfig)context.configuration().getConfigData(AtomicBatchConfig.class)).isEnabled(), (ResponseCodeEnum)ResponseCodeEnum.NOT_SUPPORTED);
        HandleException.validateFalse(((long)op.transactions().size() > ((AtomicBatchConfig)context.configuration().getConfigData(AtomicBatchConfig.class)).maxNumberOfTransactions() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.BATCH_SIZE_LIMIT_EXCEEDED);
        List txns = op.transactions();
        RecordedFeeCharging recordedFeeCharging = new RecordedFeeCharging(this.appFeeCharging.get());
        HashMap nonceAdjustments = new HashMap();
        boolean batchHasMoreThanOneContractOp = false;
        int n = txns.size();
        for (int i = 0; i < n; ++i) {
            Bytes txnBytes = (Bytes)txns.get(i);
            TransactionBody innerTxnBody = this.innerTxnCache.computeIfAbsentUnchecked(txnBytes);
            AccountID payerId = innerTxnBody.transactionIDOrThrow().accountIDOrThrow();
            HandleContext.DispatchMetadata dispatchMetadata = new HandleContext.DispatchMetadata(HandleContext.DispatchMetadata.Type.INNER_TRANSACTION_BYTES, (Object)txnBytes);
            DispatchOptions dispatchOptions = DispatchOptions.atomicBatchDispatch((AccountID)payerId, (TransactionBody)innerTxnBody, ReplayableFeeStreamBuilder.class, (FeeCharging)recordedFeeCharging, (HandleContext.DispatchMetadata)dispatchMetadata);
            if (innerTxnBody.hasEthereumTransaction()) {
                BiConsumer<AccountID, Long> nonceUpdateCallback = nonceAdjustments::put;
                dispatchMetadata.putMetadata(HandleContext.DispatchMetadata.Type.ETHEREUM_NONCE_INCREMENT_CALLBACK, nonceUpdateCallback);
            }
            if (CONTRACT_OP_BODIES.contains(innerTxnBody.data().kind())) {
                if (!batchHasMoreThanOneContractOp) {
                    batchHasMoreThanOneContractOp = this.includesContractOp(txns.subList(i + 1, n));
                }
                dispatchMetadata.putMetadata(HandleContext.DispatchMetadata.Type.EXPLICIT_WRITE_TRACING, (Object)batchHasMoreThanOneContractOp);
            }
            recordedFeeCharging.startRecording();
            ReplayableFeeStreamBuilder streamBuilder = (ReplayableFeeStreamBuilder)context.dispatch(dispatchOptions);
            recordedFeeCharging.finishRecordingTo(streamBuilder);
            if (streamBuilder.status() == ResponseCodeEnum.SUCCESS) continue;
            TokenServiceApi tokenServiceApi = (TokenServiceApi)context.storeFactory().serviceApi(TokenServiceApi.class);
            throw new HandleException(ResponseCodeEnum.INNER_TRANSACTION_FAILED, ctx -> {
                recordedFeeCharging.forEachRecorded((builder, charges) -> {
                    TreeMap<AccountID, Long> adjustments = new TreeMap<AccountID, Long>(HapiUtils.ACCOUNT_ID_COMPARATOR);
                    charges.forEach(charge -> charge.replay((FeeCharging.Context)ctx, (id, amount) -> adjustments.merge((AccountID)id, amount, Long::sum)));
                    builder.setReplayedFees(AtomicBatchHandler.asTransferList(adjustments));
                });
                nonceAdjustments.forEach((arg_0, arg_1) -> ((TokenServiceApi)tokenServiceApi).setNonce(arg_0, arg_1));
            });
        }
    }

    private boolean includesContractOp(@NonNull List<Bytes> txns) {
        for (Bytes txnBytes : txns) {
            TransactionBody innerTxnBody = this.innerTxnCache.computeIfAbsentUnchecked(txnBytes);
            if (!CONTRACT_OP_BODIES.contains(innerTxnBody.data().kind())) continue;
            return true;
        }
        return false;
    }

    private boolean isNotAllowedFunction(@NonNull TransactionBody transactionBody, @NonNull AtomicBatchConfig config) {
        try {
            HederaFunctionality hederaFunctionality = HapiUtils.functionOf((TransactionBody)transactionBody);
            return config.blacklist().functionalitySet().contains(hederaFunctionality);
        }
        catch (UnknownHederaFunctionality e) {
            return true;
        }
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        FeeCalculator calculator = feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT);
        calculator.resetUsage();
        calculator.addVerificationsPerTransaction((long)Math.max(0, feeContext.numTxnSignatures() - 1));
        return calculator.calculate();
    }

    private static TransferList asTransferList(@NonNull SortedMap<AccountID, Long> adjustments) {
        return new TransferList(adjustments.entrySet().stream().map(entry -> AccountAmount.newBuilder().accountID((AccountID)entry.getKey()).amount(((Long)entry.getValue()).longValue()).build()).toList());
    }

    public static class RecordedFeeCharging
    implements FeeCharging {
        private final FeeCharging delegate;
        private final List<ChargingEvent> chargingEvents = new ArrayList<ChargingEvent>();
        @Nullable
        private Charge finalCharge;

        public RecordedFeeCharging(@NonNull FeeCharging delegate) {
            this.delegate = Objects.requireNonNull(delegate);
        }

        public void startRecording() {
            this.finalCharge = null;
        }

        public void finishRecordingTo(@NonNull ReplayableFeeStreamBuilder streamBuilder) {
            Objects.requireNonNull(streamBuilder);
            this.chargingEvents.add(new ChargingEvent(streamBuilder, this.finalCharge == null ? Collections.emptyList() : Collections.singletonList(this.finalCharge)));
        }

        public void forEachRecorded(@NonNull BiConsumer<ReplayableFeeStreamBuilder, List<Charge>> cb) {
            this.chargingEvents.forEach(event -> cb.accept(event.streamBuilder(), event.charges()));
        }

        public FeeCharging.Validation validate(@NonNull Account payer, @NonNull AccountID creatorId, @NonNull Fees fees, @NonNull TransactionBody body, boolean isDuplicate, @NonNull HederaFunctionality function, @NonNull HandleContext.TransactionCategory category) {
            return this.delegate.validate(payer, creatorId, fees, body, isDuplicate, function, category);
        }

        public Fees charge(@NonNull FeeCharging.Context ctx, @NonNull FeeCharging.Validation validation, @NonNull Fees fees) {
            RecordingContext recordingContext = new RecordingContext(ctx, charge -> {
                this.finalCharge = charge;
            });
            return this.delegate.charge((FeeCharging.Context)recordingContext, validation, fees);
        }

        public void refund(@NonNull FeeCharging.Context ctx, @NonNull Fees fees) {
            this.delegate.refund(ctx, fees);
        }

        public record Charge(@NonNull AccountID payerId, @NonNull Fees fees, @Nullable AccountID nodeAccountId) {
            public void replay(@NonNull FeeCharging.Context ctx, @NonNull ObjLongConsumer<AccountID> cb) {
                if (this.nodeAccountId == null) {
                    ctx.charge(this.payerId, this.fees, cb);
                } else {
                    ctx.charge(this.payerId, this.fees, this.nodeAccountId, cb);
                }
            }
        }

        private record ChargingEvent(@NonNull ReplayableFeeStreamBuilder streamBuilder, @NonNull List<Charge> charges) {
        }

        private static class RecordingContext
        implements FeeCharging.Context {
            private final FeeCharging.Context delegate;
            private final Consumer<Charge> chargeCb;

            public AccountID payerId() {
                return this.delegate.payerId();
            }

            public AccountID nodeAccountId() {
                return this.delegate.nodeAccountId();
            }

            public RecordingContext(@NonNull FeeCharging.Context delegate, @NonNull Consumer<Charge> chargeCb) {
                this.delegate = Objects.requireNonNull(delegate);
                this.chargeCb = Objects.requireNonNull(chargeCb);
            }

            public Fees charge(@NonNull AccountID payerId, @NonNull Fees fees, @Nullable ObjLongConsumer<AccountID> cb) {
                Fees chargedFees = this.delegate.charge(payerId, fees, cb);
                this.chargeCb.accept(new Charge(payerId, fees, null));
                return chargedFees;
            }

            public void refund(@NonNull AccountID payerId, @NonNull Fees fees, @NonNull AccountID nodeAccountId) {
                this.delegate.refund(payerId, fees, nodeAccountId);
            }

            public void refund(@NonNull AccountID receiverId, @NonNull Fees fees) {
                this.delegate.refund(receiverId, fees);
            }

            public Fees charge(@NonNull AccountID payerId, @NonNull Fees fees, @NonNull AccountID nodeAccountId, @Nullable ObjLongConsumer<AccountID> cb) {
                Fees chargedFees = this.delegate.charge(payerId, fees, nodeAccountId, cb);
                this.chargeCb.accept(new Charge(payerId, fees, nodeAccountId));
                return chargedFees;
            }

            public HandleContext.TransactionCategory category() {
                return this.delegate.category();
            }
        }
    }
}

