/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.ethereum.rlp;

import java.util.function.IntUnaryOperator;
import java.util.function.LongUnaryOperator;
import org.hyperledger.besu.ethereum.rlp.CorruptedRLPInputException;
import org.hyperledger.besu.ethereum.rlp.MalformedRLPInputException;
import org.hyperledger.besu.ethereum.rlp.RLPException;

class RLPDecodingHelpers {
    RLPDecodingHelpers() {
    }

    static int extractSize(IntUnaryOperator getter, int offset, int sizeLength) {
        int res = 0;
        int shift = 0;
        for (int i = 0; i < sizeLength; ++i) {
            res |= (getter.applyAsInt(offset + (sizeLength - 1) - i) & 0xFF) << shift;
            shift += 8;
        }
        return res;
    }

    private static int extractSizeFromLongItem(LongUnaryOperator getter, long offset, int sizeLength) {
        if (sizeLength > 4) {
            throw new RLPException("RLP item at offset " + offset + " with size value consuming " + sizeLength + " bytes exceeds max supported size of 2147483647");
        }
        long res = 0L;
        int shift = 0;
        for (int i = 0; i < sizeLength; ++i) {
            res |= (getter.applyAsLong(offset + (long)(sizeLength - 1) - (long)i) & 0xFFL) << shift;
            shift += 8;
        }
        try {
            return Math.toIntExact(res);
        }
        catch (ArithmeticException e) {
            throw new RLPException("RLP item at offset " + offset + " with size value consuming " + sizeLength + " bytes exceeds max supported size of 2147483647", e);
        }
    }

    static RLPElementMetadata rlpElementMetadata(LongUnaryOperator byteGetter, long size, long elementStart) {
        int prefix = Math.toIntExact(byteGetter.applyAsLong(elementStart)) & 0xFF;
        Kind kind = Kind.of(prefix);
        long payloadStart = 0L;
        int payloadSize = 0;
        switch (kind) {
            case BYTE_ELEMENT: {
                payloadStart = elementStart;
                payloadSize = 1;
                break;
            }
            case SHORT_ELEMENT: {
                payloadStart = elementStart + 1L;
                payloadSize = prefix - 128;
                break;
            }
            case LONG_ELEMENT: {
                int sizeLengthElt = prefix - 183;
                payloadStart = elementStart + 1L + (long)sizeLengthElt;
                payloadSize = RLPDecodingHelpers.readLongSize(byteGetter, size, elementStart, sizeLengthElt);
                break;
            }
            case SHORT_LIST: {
                payloadStart = elementStart + 1L;
                payloadSize = prefix - 192;
                break;
            }
            case LONG_LIST: {
                int sizeLengthList = prefix - 247;
                payloadStart = elementStart + 1L + (long)sizeLengthList;
                payloadSize = RLPDecodingHelpers.readLongSize(byteGetter, size, elementStart, sizeLengthList);
            }
        }
        return new RLPElementMetadata(kind, elementStart, payloadStart, payloadSize);
    }

    private static int readLongSize(LongUnaryOperator byteGetter, long sizeOfRlpEncodedByteString, long item, int sizeLength) {
        if (sizeOfRlpEncodedByteString - (item + 1L) < (long)sizeLength) {
            throw new CorruptedRLPInputException(String.format("Invalid RLP item: value of size %d has not enough bytes to read the %d bytes payload size", sizeOfRlpEncodedByteString, sizeLength));
        }
        if (byteGetter.applyAsLong(item + 1L) == 0L) {
            throw new MalformedRLPInputException("Malformed RLP item: size of payload has leading zeros");
        }
        int res = RLPDecodingHelpers.extractSizeFromLongItem(byteGetter, item + 1L, sizeLength);
        if (res < 56) {
            throw new MalformedRLPInputException(String.format("Malformed RLP item: written as a long item, but size %d < 56 bytes", res));
        }
        return res;
    }

    static enum Kind {
        BYTE_ELEMENT,
        SHORT_ELEMENT,
        LONG_ELEMENT,
        SHORT_LIST,
        LONG_LIST;


        static Kind of(int prefix) {
            if (prefix <= 127) {
                return BYTE_ELEMENT;
            }
            if (prefix <= 183) {
                return SHORT_ELEMENT;
            }
            if (prefix <= 191) {
                return LONG_ELEMENT;
            }
            if (prefix <= 247) {
                return SHORT_LIST;
            }
            return LONG_LIST;
        }

        boolean isList() {
            switch (this) {
                case SHORT_LIST: 
                case LONG_LIST: {
                    return true;
                }
            }
            return false;
        }
    }

    static class RLPElementMetadata {
        final Kind kind;
        final long elementStart;
        final long payloadStart;
        final int payloadSize;

        RLPElementMetadata(Kind kind, long elementStart, long payloadStart, int payloadSize) {
            this.kind = kind;
            this.elementStart = elementStart;
            this.payloadStart = payloadStart;
            this.payloadSize = payloadSize;
        }

        int getEncodedSize() {
            long encodedSize = this.elementEnd() - this.elementStart + 1L;
            try {
                return Math.toIntExact(encodedSize);
            }
            catch (ArithmeticException e) {
                throw new RLPException(String.format("RLP item exceeds max supported size of %d: %d", Integer.MAX_VALUE, encodedSize), e);
            }
        }

        long elementEnd() {
            return this.payloadStart + (long)this.payloadSize - 1L;
        }
    }
}

