/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.services;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.node.state.token.NodeActivity;
import com.hedera.hapi.node.state.token.NodeRewards;
import com.hedera.hapi.platform.state.JudgeId;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.hapi.fees.pricing.FeeSchedules;
import com.hedera.node.app.ids.ReadableEntityIdStoreImpl;
import com.hedera.node.app.metrics.NodeMetrics;
import com.hedera.node.app.service.token.impl.ReadableAccountStoreImpl;
import com.hedera.node.app.service.token.impl.ReadableNetworkStakingRewardsStoreImpl;
import com.hedera.node.app.service.token.impl.WritableNetworkStakingRewardsStore;
import com.hedera.node.app.service.token.impl.WritableNodeRewardsStoreImpl;
import com.hedera.node.app.service.token.impl.schemas.V0610TokenSchema;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.app.workflows.handle.record.SystemTransactions;
import com.hedera.node.app.workflows.handle.steps.StakePeriodChanges;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.NodesConfig;
import com.hedera.node.config.data.StakingConfig;
import com.swirlds.platform.state.service.schemas.V0540PlatformStateSchema;
import com.swirlds.state.State;
import com.swirlds.state.spi.CommittableWritableStates;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.roster.ReadableRosterStoreImpl;

@Singleton
public class NodeRewardManager {
    private static final Logger log = LogManager.getLogger(NodeRewardManager.class);
    private final ConfigProvider configProvider;
    private final EntityIdFactory entityIdFactory;
    private final ExchangeRateManager exchangeRateManager;
    private long roundsThisStakingPeriod = 0L;
    private final SortedMap<Long, Long> missedJudgeCounts = new TreeMap<Long, Long>();
    private final NodeMetrics metrics;

    @Inject
    public NodeRewardManager(@NonNull ConfigProvider configProvider, @NonNull EntityIdFactory entityIdFactory, @NonNull ExchangeRateManager exchangeRateManager, @Nullable NodeMetrics metrics) {
        this.configProvider = Objects.requireNonNull(configProvider);
        this.entityIdFactory = Objects.requireNonNull(entityIdFactory);
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager);
        this.metrics = metrics;
    }

    public void onOpenBlock(@NonNull State state) {
        if (((NodesConfig)this.configProvider.getConfiguration().getConfigData(NodesConfig.class)).nodeRewardsEnabled()) {
            this.missedJudgeCounts.clear();
            NodeRewards nodeRewardInfo = this.nodeRewardInfoFrom(state);
            this.roundsThisStakingPeriod = nodeRewardInfo.numRoundsInStakingPeriod();
            nodeRewardInfo.nodeActivities().forEach(activity -> this.missedJudgeCounts.put(activity.nodeId(), activity.numMissedJudgeRounds()));
        }
    }

    public void onCloseBlock(@NonNull State state, long nodeFeesCollected) {
        if (((NodesConfig)this.configProvider.getConfiguration().getConfigData(NodesConfig.class)).nodeRewardsEnabled()) {
            this.updateNodeRewardState(state, nodeFeesCollected);
        }
    }

    public void updateJudgesOnEndRound(State state) {
        ++this.roundsThisStakingPeriod;
        this.missingJudgesInLastRoundOf(state).forEach(nodeId -> this.missedJudgeCounts.compute((Long)nodeId, (k, v) -> v == null ? this.roundsThisStakingPeriod : v + 1L));
    }

    public void resetNodeRewards() {
        this.missedJudgeCounts.clear();
        this.roundsThisStakingPeriod = 0L;
    }

    private LastNodeRewardsPaymentTime classifyLastNodeRewardsPaymentTime(@NonNull State state, @NonNull Instant now) {
        ReadableNetworkStakingRewardsStoreImpl networkRewardsStore = new ReadableNetworkStakingRewardsStoreImpl(state.getReadableStates("TokenService"));
        Timestamp lastPaidTime = networkRewardsStore.get().lastNodeRewardPaymentsTime();
        if (lastPaidTime == null) {
            return LastNodeRewardsPaymentTime.NEVER;
        }
        long stakePeriodMins = ((StakingConfig)this.configProvider.getConfiguration().getConfigData(StakingConfig.class)).periodMins();
        boolean isNextPeriod = StakePeriodChanges.isNextStakingPeriod(now, HapiUtils.asInstant((Timestamp)lastPaidTime), stakePeriodMins);
        return isNextPeriod ? LastNodeRewardsPaymentTime.PREVIOUS_PERIOD : LastNodeRewardsPaymentTime.CURRENT_PERIOD;
    }

    public boolean maybeRewardActiveNodes(@NonNull State state, @NonNull Instant now, SystemTransactions systemTransactions) {
        VersionedConfiguration config = this.configProvider.getConfiguration();
        NodesConfig nodesConfig = (NodesConfig)config.getConfigData(NodesConfig.class);
        if (!nodesConfig.nodeRewardsEnabled()) {
            return false;
        }
        LastNodeRewardsPaymentTime lastNodeRewardsPaymentTime = this.classifyLastNodeRewardsPaymentTime(state, now);
        if (lastNodeRewardsPaymentTime == LastNodeRewardsPaymentTime.CURRENT_PERIOD) {
            return false;
        }
        WritableStates writableStates = state.getWritableStates("TokenService");
        WritableNodeRewardsStoreImpl nodeRewardStore = new WritableNodeRewardsStoreImpl(writableStates);
        if (lastNodeRewardsPaymentTime == LastNodeRewardsPaymentTime.PREVIOUS_PERIOD) {
            log.info("Considering paying node rewards for the last staking period at {}", (Object)HapiUtils.asTimestamp((Instant)now));
            ReadableRosterStoreImpl rosterStore = new ReadableRosterStoreImpl(state.getReadableStates("RosterService"));
            List currentRoster = Objects.requireNonNull(rosterStore.getActiveRoster()).rosterEntries();
            List activeNodeIds = nodeRewardStore.getActiveNodeIds(currentRoster, nodesConfig.activeRoundsPercent());
            this.updateNodeMetrics(currentRoster, nodeRewardStore);
            AccountID rewardsAccountId = this.entityIdFactory.newAccountId(((AccountsConfig)config.getConfigData(AccountsConfig.class)).nodeRewardAccount());
            ReadableEntityIdStoreImpl entityCounters = new ReadableEntityIdStoreImpl(state.getReadableStates("EntityIdService"));
            ReadableAccountStoreImpl accountStore = new ReadableAccountStoreImpl((ReadableStates)writableStates, (ReadableEntityCounters)entityCounters);
            long rewardAccountBalance = Objects.requireNonNull(accountStore.getAccountById(rewardsAccountId)).tinybarBalance();
            long prePaidRewards = nodesConfig.adjustNodeFees() ? nodeRewardStore.get().nodeFeesCollected() / (long)currentRoster.size() : 0L;
            BigInteger targetPayInTinycents = BigInteger.valueOf(nodesConfig.targetYearlyNodeRewardsUsd()).multiply(FeeSchedules.USD_TO_TINYCENTS.toBigInteger()).divide(BigInteger.valueOf(nodesConfig.numPeriodsToTargetUsd()));
            long minimumRewardInTinycents = this.exchangeRateManager.getTinybarsFromTinycents(Math.max(0L, BigInteger.valueOf(nodesConfig.minPerPeriodNodeRewardUsd()).multiply(FeeSchedules.USD_TO_TINYCENTS.toBigInteger()).longValue()), now);
            long nodeReward = this.exchangeRateManager.getTinybarsFromTinycents(targetPayInTinycents.longValue(), now);
            long perActiveNodeReward = Math.max(minimumRewardInTinycents, nodeReward - prePaidRewards);
            systemTransactions.dispatchNodeRewards(state, now, activeNodeIds, perActiveNodeReward, rewardsAccountId, rewardAccountBalance, minimumRewardInTinycents, rosterStore.getActiveRoster().rosterEntries());
        }
        WritableNetworkStakingRewardsStore rewardsStore = new WritableNetworkStakingRewardsStore(writableStates);
        rewardsStore.put(rewardsStore.get().copyBuilder().lastNodeRewardPaymentsTime(HapiUtils.asTimestamp((Instant)now)).build());
        nodeRewardStore.resetForNewStakingPeriod();
        this.resetNodeRewards();
        ((CommittableWritableStates)writableStates).commit();
        return true;
    }

    private void updateNodeMetrics(List<RosterEntry> rosterEntries, WritableNodeRewardsStoreImpl nodeRewardStore) {
        long roundsLastPeriod = nodeRewardStore.get().numRoundsInStakingPeriod();
        this.metrics.registerNodeMetrics(rosterEntries);
        Map<Long, Long> missedJudgeCounts = nodeRewardStore.get().nodeActivities().stream().collect(Collectors.toMap(NodeActivity::nodeId, NodeActivity::numMissedJudgeRounds));
        rosterEntries.forEach(node -> {
            long nodeId = node.nodeId();
            Long missedJudges = missedJudgeCounts.getOrDefault(nodeId, 0L);
            long activeRounds = Math.max(roundsLastPeriod - missedJudges, 0L);
            double activePercent = activeRounds == 0L ? 0.0 : (double)(activeRounds * 100L / roundsLastPeriod);
            this.metrics.updateNodeActiveMetrics(nodeId, activePercent);
        });
    }

    @NonNull
    private NodeRewards nodeRewardInfoFrom(@NonNull State state) {
        ReadableSingletonState nodeRewardInfoState = state.getReadableStates("TokenService").getSingleton(V0610TokenSchema.NODE_REWARDS_STATE_ID);
        return Objects.requireNonNull((NodeRewards)nodeRewardInfoState.get());
    }

    private void updateNodeRewardState(@NonNull State state, long nodeFeesCollected) {
        WritableStates writableTokenState = state.getWritableStates("TokenService");
        WritableSingletonState nodeRewardsState = writableTokenState.getSingleton(V0610TokenSchema.NODE_REWARDS_STATE_ID);
        List<NodeActivity> nodeActivities = this.missedJudgeCounts.entrySet().stream().map(entry -> NodeActivity.newBuilder().nodeId(((Long)entry.getKey()).longValue()).numMissedJudgeRounds(((Long)entry.getValue()).longValue()).build()).toList();
        long newNodeFeesCollected = Objects.requireNonNull((NodeRewards)nodeRewardsState.get()).nodeFeesCollected() + nodeFeesCollected;
        nodeRewardsState.put((Object)NodeRewards.newBuilder().nodeActivities(nodeActivities).numRoundsInStakingPeriod(this.roundsThisStakingPeriod).nodeFeesCollected(newNodeFeesCollected).build());
        ((CommittableWritableStates)writableTokenState).commit();
    }

    private List<Long> missingJudgesInLastRoundOf(@NonNull State state) {
        ReadableSingletonState readablePlatformState = state.getReadableStates("PlatformStateService").getSingleton(V0540PlatformStateSchema.PLATFORM_STATE_STATE_ID);
        ReadableRosterStoreImpl rosterStore = new ReadableRosterStoreImpl(state.getReadableStates("RosterService"));
        HashSet judges = Objects.requireNonNull((PlatformState)readablePlatformState.get()).consensusSnapshot().judgeIds().stream().map(JudgeId::creatorId).collect(Collectors.toCollection(HashSet::new));
        return Objects.requireNonNull(rosterStore.getActiveRoster()).rosterEntries().stream().map(RosterEntry::nodeId).filter(nodeId -> !judges.contains(nodeId)).toList();
    }

    @VisibleForTesting
    public long getRoundsThisStakingPeriod() {
        return this.roundsThisStakingPeriod;
    }

    @VisibleForTesting
    public SortedMap<Long, Long> getMissedJudgeCounts() {
        return this.missedJudgeCounts;
    }

    private static enum LastNodeRewardsPaymentTime {
        NEVER,
        PREVIOUS_PERIOD,
        CURRENT_PERIOD;

    }
}

