/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.contractvalidation;

import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.contractvalidation.ContractValidationRule;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaxCodeSizeRule
implements ContractValidationRule {
    private static final Logger LOG = LoggerFactory.getLogger(MaxCodeSizeRule.class);
    private final int maxCodeSize;

    MaxCodeSizeRule(int maxCodeSize) {
        this.maxCodeSize = maxCodeSize;
    }

    @Override
    public Optional<ExceptionalHaltReason> validate(Bytes contractCode, MessageFrame frame) {
        int contractCodeSize = contractCode.size();
        if (contractCodeSize <= this.maxCodeSize) {
            return Optional.empty();
        }
        LOG.trace("Contract creation error: code size {} exceeds code size limit {}", (Object)contractCodeSize, (Object)this.maxCodeSize);
        return Optional.of(ExceptionalHaltReason.CODE_TOO_LARGE);
    }

    public static ContractValidationRule of(int maxCodeSize) {
        return new MaxCodeSizeRule(maxCodeSize);
    }
}

