/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.LongByReference;
import com.sun.jna.ptr.PointerByReference;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.HMacDSAKCalculator;
import org.bouncycastle.math.ec.custom.sec.SecP256K1Curve;
import org.hyperledger.besu.crypto.AbstractSECP256;
import org.hyperledger.besu.crypto.KeyPair;
import org.hyperledger.besu.crypto.SECPPublicKey;
import org.hyperledger.besu.crypto.SECPSignature;
import org.hyperledger.besu.nativelib.secp256k1.LibSecp256k1;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SECP256K1
extends AbstractSECP256 {
    private static final Logger LOG = LoggerFactory.getLogger(SECP256K1.class);
    private boolean useNative;
    public static final String CURVE_NAME = "secp256k1";

    public SECP256K1() {
        super(CURVE_NAME, SecP256K1Curve.q);
        this.maybeEnableNative();
    }

    @Override
    public void disableNative() {
        this.useNative = false;
    }

    public boolean maybeEnableNative() {
        try {
            this.useNative = LibSecp256k1.CONTEXT != null;
        }
        catch (NoClassDefFoundError | UnsatisfiedLinkError e) {
            LOG.info("Native secp256k1 not available - {}", (Object)e.getMessage());
            this.useNative = false;
        }
        return this.useNative;
    }

    @Override
    public boolean isNative() {
        return this.useNative;
    }

    @Override
    public DSAKCalculator getKCalculator() {
        return new HMacDSAKCalculator((Digest)new SHA256Digest());
    }

    @Override
    public SECPSignature sign(Bytes32 dataHash, KeyPair keyPair) {
        if (this.useNative) {
            return this.signNative(dataHash, keyPair);
        }
        return super.sign(dataHash, keyPair);
    }

    @Override
    public boolean verify(Bytes data, SECPSignature signature, SECPPublicKey pub) {
        if (this.useNative) {
            return this.verifyNative(data, signature, pub);
        }
        return super.verify(data, signature, pub);
    }

    @Override
    public Optional<SECPPublicKey> recoverPublicKeyFromSignature(Bytes32 dataHash, SECPSignature signature) {
        if (this.useNative) {
            Optional<SECPPublicKey> result = this.recoverFromSignatureNative(dataHash, signature);
            if (result.isEmpty()) {
                throw new IllegalArgumentException("Could not recover public key");
            }
            return result;
        }
        return super.recoverPublicKeyFromSignature(dataHash, signature);
    }

    @Override
    public String getCurveName() {
        return CURVE_NAME;
    }

    private SECPSignature signNative(Bytes32 dataHash, KeyPair keyPair) {
        LibSecp256k1.secp256k1_ecdsa_recoverable_signature signature = new LibSecp256k1.secp256k1_ecdsa_recoverable_signature();
        if (LibSecp256k1.secp256k1_ecdsa_sign_recoverable((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_ecdsa_recoverable_signature)signature, (byte[])dataHash.toArrayUnsafe(), (byte[])keyPair.getPrivateKey().getEncoded(), null, null) == 0) {
            throw new RuntimeException("Could not natively sign. Private Key is invalid or default nonce generation failed.");
        }
        ByteBuffer compactSig = ByteBuffer.allocate(64);
        IntByReference recId = new IntByReference(0);
        LibSecp256k1.secp256k1_ecdsa_recoverable_signature_serialize_compact((PointerByReference)LibSecp256k1.CONTEXT, (ByteBuffer)compactSig, (IntByReference)recId, (LibSecp256k1.secp256k1_ecdsa_recoverable_signature)signature);
        compactSig.flip();
        byte[] sig = compactSig.array();
        Bytes32 r = Bytes32.wrap((byte[])sig, (int)0);
        Bytes32 s = Bytes32.wrap((byte[])sig, (int)32);
        return SECPSignature.create(r.toUnsignedBigInteger(), s.toUnsignedBigInteger(), (byte)recId.getValue(), this.curveOrder);
    }

    private boolean verifyNative(Bytes data, SECPSignature signature, SECPPublicKey pub) {
        LibSecp256k1.secp256k1_ecdsa_signature _signature = new LibSecp256k1.secp256k1_ecdsa_signature();
        if (LibSecp256k1.secp256k1_ecdsa_signature_parse_compact((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_ecdsa_signature)_signature, (byte[])signature.encodedBytes().toArrayUnsafe()) == 0) {
            throw new IllegalArgumentException("Could not parse signature");
        }
        LibSecp256k1.secp256k1_pubkey _pub = new LibSecp256k1.secp256k1_pubkey();
        Bytes encodedPubKey = Bytes.concatenate((Bytes[])new Bytes[]{Bytes.of((int[])new int[]{4}), pub.getEncodedBytes()});
        if (LibSecp256k1.secp256k1_ec_pubkey_parse((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_pubkey)_pub, (byte[])encodedPubKey.toArrayUnsafe(), (long)encodedPubKey.size()) == 0) {
            throw new IllegalArgumentException("Could not parse public key");
        }
        return LibSecp256k1.secp256k1_ecdsa_verify((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_ecdsa_signature)_signature, (byte[])data.toArrayUnsafe(), (LibSecp256k1.secp256k1_pubkey)_pub) != 0;
    }

    @Override
    protected BigInteger recoverFromSignature(int recId, BigInteger r, BigInteger s, Bytes32 dataHash) {
        if (this.useNative) {
            return this.recoverFromSignatureNative(dataHash, new SECPSignature(r, s, (byte)recId)).map(key -> new BigInteger(1, key.getEncoded())).orElse(null);
        }
        return super.recoverFromSignature(recId, r, s, dataHash);
    }

    private Optional<SECPPublicKey> recoverFromSignatureNative(Bytes32 dataHash, SECPSignature signature) {
        LibSecp256k1.secp256k1_ecdsa_recoverable_signature parsedSignature = new LibSecp256k1.secp256k1_ecdsa_recoverable_signature();
        Bytes encodedSig = signature.encodedBytes();
        if (LibSecp256k1.secp256k1_ecdsa_recoverable_signature_parse_compact((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_ecdsa_recoverable_signature)parsedSignature, (byte[])encodedSig.slice(0, 64).toArrayUnsafe(), (int)encodedSig.get(64)) == 0) {
            throw new IllegalArgumentException("Could not parse signature");
        }
        LibSecp256k1.secp256k1_pubkey newPubKey = new LibSecp256k1.secp256k1_pubkey();
        if (LibSecp256k1.secp256k1_ecdsa_recover((PointerByReference)LibSecp256k1.CONTEXT, (LibSecp256k1.secp256k1_pubkey)newPubKey, (LibSecp256k1.secp256k1_ecdsa_recoverable_signature)parsedSignature, (byte[])dataHash.toArrayUnsafe()) == 0) {
            return Optional.empty();
        }
        ByteBuffer recoveredKey = ByteBuffer.allocate(65);
        LongByReference keySize = new LongByReference((long)recoveredKey.limit());
        LibSecp256k1.secp256k1_ec_pubkey_serialize((PointerByReference)LibSecp256k1.CONTEXT, (ByteBuffer)recoveredKey, (LongByReference)keySize, (LibSecp256k1.secp256k1_pubkey)newPubKey, (int)2);
        return Optional.of(SECPPublicKey.create(Bytes.wrapByteBuffer((ByteBuffer)recoveredKey).slice(1), "ECDSA"));
    }
}

