/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.collections.undo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javax.annotation.Nonnull;
import org.hyperledger.besu.collections.undo.Undoable;

public class UndoList<V>
implements List<V>,
Undoable {
    List<V> delegate;
    List<UndoEntry<V>> undoLog = new ArrayList<UndoEntry<V>>();

    public UndoList(List<V> delegate) {
        this.delegate = delegate;
    }

    @Override
    public void undo(long mark) {
        for (int pos = this.undoLog.size() - 1; pos >= 0 && this.undoLog.get((int)pos).level > mark; --pos) {
            UndoEntry<V> entry = this.undoLog.get(pos);
            this.undoLog.remove(pos);
            if (entry.value() == null) {
                this.delegate.remove(entry.index);
                continue;
            }
            if (entry.set) {
                this.delegate.set(entry.index, entry.value());
                continue;
            }
            this.delegate.add(entry.index, entry.value);
        }
    }

    @Override
    public long lastUpdate() {
        return this.undoLog.isEmpty() ? 0L : this.undoLog.get((int)(this.undoLog.size() - 1)).level;
    }

    @Override
    public boolean add(V v) {
        this.undoLog.add(new UndoEntry<Object>(this.delegate.size(), false, null));
        return this.delegate.add(v);
    }

    @Override
    public boolean remove(Object v) {
        int index = this.delegate.indexOf(v);
        if (index >= 0) {
            this.delegate.remove(index);
            this.undoLog.add(new UndoEntry<Object>(index, false, v));
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(@Nonnull Collection<?> c) {
        return new HashSet<V>(this.delegate).containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        for (V v : c) {
            this.add(v);
        }
        return !c.isEmpty();
    }

    @Override
    public boolean addAll(int index, Collection<? extends V> c) {
        int pos = index;
        for (V v : c) {
            this.add(pos++, v);
        }
        return !c.isEmpty();
    }

    @Override
    public boolean removeAll(@Nonnull Collection<?> c) {
        HashSet hs = new HashSet(c);
        ListIterator<V> iter = this.delegate.listIterator();
        boolean updated = false;
        while (iter.hasNext()) {
            V v = iter.next();
            if (!hs.contains(v)) continue;
            this.undoLog.add(new UndoEntry<V>(iter.previousIndex(), false, v));
            iter.remove();
            updated = true;
        }
        return updated;
    }

    @Override
    public boolean retainAll(@Nonnull Collection<?> c) {
        HashSet hs = new HashSet(c);
        ListIterator<V> iter = this.delegate.listIterator();
        boolean updated = false;
        while (iter.hasNext()) {
            V v = iter.next();
            if (hs.contains(v)) continue;
            this.undoLog.add(new UndoEntry<V>(iter.previousIndex(), false, v));
            iter.remove();
            updated = true;
        }
        return updated;
    }

    @Override
    public void clear() {
        for (int i = this.delegate.size() - 1; i >= 0; --i) {
            this.remove(i);
        }
    }

    @Override
    public V set(int index, V element) {
        V oldValue = this.delegate.set(index, element);
        this.undoLog.add(new UndoEntry<V>(index, true, oldValue));
        return oldValue;
    }

    @Override
    public void add(int index, V element) {
        this.delegate.add(index, element);
        this.undoLog.add(new UndoEntry<Object>(index, false, null));
    }

    @Override
    public V remove(int index) {
        this.undoLog.add(new UndoEntry<V>(index, false, this.delegate.get(index)));
        return this.delegate.remove(index);
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.contains(o);
    }

    @Override
    public Iterator<V> iterator() {
        return this.delegate.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.toArray();
    }

    @Override
    public <T> T[] toArray(@Nonnull T[] a) {
        return this.delegate.toArray(a);
    }

    @Override
    public V get(int index) {
        return this.delegate.get(index);
    }

    @Override
    public int indexOf(Object o) {
        return this.delegate.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.delegate.lastIndexOf(o);
    }

    @Override
    public ListIterator<V> listIterator() {
        return new ReadOnlyListIterator<V>(this.delegate.listIterator());
    }

    @Override
    public ListIterator<V> listIterator(int index) {
        return new ReadOnlyListIterator<V>(this.delegate.listIterator(index));
    }

    @Override
    public List<V> subList(int fromIndex, int toIndex) {
        return this.delegate.subList(fromIndex, toIndex);
    }

    public String toString() {
        return "UndoList{delegate=" + this.delegate + ", undoLog=" + this.undoLog + "}";
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof UndoList && this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode() ^ 0xDE1E647E;
    }

    record UndoEntry<V>(int index, boolean set, V value, long level) {
        UndoEntry(int index, boolean set, V value) {
            this(index, set, value, Undoable.incrementMarkStatic());
        }

        @Override
        public String toString() {
            return "UndoEntry{index=" + this.index + ", set=" + this.set + ", value=" + this.value + ", level=" + this.level + "}";
        }
    }

    static class ReadOnlyListIterator<V>
    implements ListIterator<V> {
        ListIterator<V> iterDelegate;

        public ReadOnlyListIterator(ListIterator<V> iterDelegate) {
            this.iterDelegate = iterDelegate;
        }

        @Override
        public boolean hasNext() {
            return this.iterDelegate.hasNext();
        }

        @Override
        public V next() {
            return this.iterDelegate.next();
        }

        @Override
        public boolean hasPrevious() {
            return this.iterDelegate.hasPrevious();
        }

        @Override
        public V previous() {
            return this.iterDelegate.previous();
        }

        @Override
        public int nextIndex() {
            return this.iterDelegate.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.iterDelegate.previousIndex();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("UndoList does not support iterator based modification");
        }

        @Override
        public void set(V v) {
            throw new UnsupportedOperationException("UndoList does not support iterator based modification");
        }

        @Override
        public void add(V v) {
            throw new UnsupportedOperationException("UndoList does not support iterator based modification");
        }
    }
}

