/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.operation.RelativeJumpOperation;

public class RelativeJumpIfOperation
extends RelativeJumpOperation {
    public static final int OPCODE = 225;

    public RelativeJumpIfOperation(GasCalculator gasCalculator) {
        super(225, "RJUMPI", 0, 0, gasCalculator, 4L);
    }

    @Override
    protected Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        Bytes condition = frame.popStackItem();
        if (!condition.isZero()) {
            return super.executeFixedCostOperation(frame, evm);
        }
        return new Operation.OperationResult(this.gasCost, null, 3);
    }
}

