/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.parameters.Parameters;
import io.helidon.common.uri.UriPath;
import io.helidon.http.HttpException;
import io.helidon.http.RoutedPath;
import io.helidon.http.Status;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.ServerLifecycle;
import io.helidon.webserver.WebServer;
import io.helidon.webserver.http.ErrorHandlers;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.FilterChain;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;

public final class Filters
implements ServerLifecycle {
    private final ErrorHandlers errorHandlers;
    private final List<Filter> filters;
    private final boolean noFilters;

    private Filters(ErrorHandlers errorHandlers, List<Filter> filters) {
        this.errorHandlers = errorHandlers;
        this.filters = filters;
        this.noFilters = filters.isEmpty();
    }

    public static Filters create(ErrorHandlers errorHandlers, List<Filter> filters) {
        return new Filters(errorHandlers, filters);
    }

    @Override
    public void beforeStart() {
        this.filters.forEach(ServerLifecycle::beforeStart);
    }

    @Override
    public void afterStart(WebServer webServer) {
        this.filters.forEach(f -> f.afterStart(webServer));
    }

    @Override
    public void afterStop() {
        this.filters.forEach(ServerLifecycle::afterStop);
    }

    public void filter(ConnectionContext ctx, RoutingRequest request, RoutingResponse response, Callable<Void> routingExecutor) {
        if (this.noFilters) {
            this.errorHandlers.runWithErrorHandling(ctx, request, response, routingExecutor);
            return;
        }
        FilterChainImpl chain = new FilterChainImpl(ctx, this.errorHandlers, this.filters, request, response, routingExecutor);
        request.path(new FilterRoutedPath(request.prologue().uriPath()));
        this.errorHandlers.runWithErrorHandling(ctx, request, response, () -> this.executeFilters(chain));
    }

    private Void executeFilters(FilterChain chain) {
        chain.proceed();
        return null;
    }

    private static final class FilterChainImpl
    implements FilterChain {
        private final ConnectionContext ctx;
        private final ErrorHandlers errorHandlers;
        private final Iterator<Filter> filters;
        private final Callable<Void> routingExecutor;
        private final RoutingRequest request;
        private final RoutingResponse response;

        private FilterChainImpl(ConnectionContext ctx, ErrorHandlers errorHandlers, List<Filter> filters, RoutingRequest request, RoutingResponse response, Callable<Void> routingExecutor) {
            this.ctx = ctx;
            this.errorHandlers = errorHandlers;
            this.filters = filters.iterator();
            this.request = request;
            this.response = response;
            this.routingExecutor = routingExecutor;
        }

        @Override
        public void proceed() {
            if (this.response.hasEntity()) {
                return;
            }
            if (this.filters.hasNext()) {
                this.filters.next().filter(this, this.request, this.response);
            } else {
                this.errorHandlers.runWithErrorHandling(this.ctx, this.request, this.response, this.routingExecutor);
                if (!this.response.isSent()) {
                    throw new HttpException("Routing finished but response was not sent. Helidon WebServer does not support asynchronous responses. Please block until a response can be sent.", Status.INTERNAL_SERVER_ERROR_500);
                }
            }
        }
    }

    private static final class FilterRoutedPath
    implements RoutedPath {
        private static final Parameters EMPTY_PARAMS = Parameters.empty((String)"http/path");
        private final UriPath uriPath;

        FilterRoutedPath(UriPath uriPath) {
            this.uriPath = uriPath;
        }

        public String rawPath() {
            return this.uriPath.rawPath();
        }

        public String rawPathNoParams() {
            return this.uriPath.rawPathNoParams();
        }

        public String path() {
            return this.uriPath.path();
        }

        public Parameters matrixParameters() {
            return this.uriPath.matrixParameters();
        }

        public void validate() {
            this.uriPath.validate();
        }

        public Parameters pathParameters() {
            return EMPTY_PARAMS;
        }

        public RoutedPath absolute() {
            return new FilterRoutedPath(this.uriPath.absolute());
        }
    }
}

