/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.processors;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.streams.ContractActionType;
import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HederaSystemContract;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts.create.CreateCommons;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.OpsDurationCounter;
import com.hedera.node.app.service.contract.impl.hevm.HevmPropagatedCallFailure;
import com.hedera.node.app.service.contract.impl.hevm.OpsDurationSchedule;
import com.hedera.node.app.service.contract.impl.state.ProxyEvmContract;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.account.Account;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.precompile.PrecompileContractRegistry;
import org.hyperledger.besu.evm.precompile.PrecompiledContract;
import org.hyperledger.besu.evm.processor.MessageCallProcessor;
import org.hyperledger.besu.evm.tracing.OperationTracer;

public class CustomMessageCallProcessor
extends MessageCallProcessor {
    private final FeatureFlags featureFlags;
    private final AddressChecks addressChecks;
    private final PrecompileContractRegistry precompiles;
    private final Map<Address, HederaSystemContract> systemContracts;
    private final ContractMetrics contractMetrics;

    public CustomMessageCallProcessor(@NonNull EVM evm, @NonNull FeatureFlags featureFlags, @NonNull PrecompileContractRegistry precompiles, @NonNull AddressChecks addressChecks, @NonNull Map<Address, HederaSystemContract> systemContracts, @NonNull ContractMetrics contractMetrics) {
        super(evm, precompiles);
        this.featureFlags = Objects.requireNonNull(featureFlags);
        this.precompiles = Objects.requireNonNull(precompiles);
        this.addressChecks = Objects.requireNonNull(addressChecks);
        this.systemContracts = Objects.requireNonNull(systemContracts);
        this.contractMetrics = Objects.requireNonNull(contractMetrics);
    }

    public void start(@NonNull MessageFrame frame, @NonNull OperationTracer tracer) {
        Account maybeCalledContract;
        Address codeAddress = frame.getContractAddress();
        if (this.systemContracts.containsKey(codeAddress)) {
            if (!this.isTokenCreation(frame)) {
                this.doHaltIfInvalidSystemCall(frame, tracer);
                if (FrameUtils.alreadyHalted(frame)) {
                    return;
                }
            }
            this.doExecuteSystemContract(this.systemContracts.get(codeAddress), codeAddress, frame, tracer);
            return;
        }
        PrecompiledContract evmPrecompile = this.precompiles.get(codeAddress);
        if (evmPrecompile != null && !FrameUtils.isPrecompileEnabled(codeAddress, frame)) {
            evmPrecompile = null;
        }
        if (this.addressChecks.isSystemAccount(codeAddress)) {
            this.doHaltIfInvalidSystemCall(frame, tracer);
            if (FrameUtils.alreadyHalted(frame)) {
                return;
            }
            if (evmPrecompile == null) {
                this.handleNonExtantSystemAccount(frame, tracer);
                return;
            }
        }
        if (evmPrecompile != null) {
            this.doExecutePrecompile(evmPrecompile, frame, tracer);
            return;
        }
        if (FrameUtils.transfersValue(frame)) {
            this.doTransferValueOrHalt(frame, tracer);
            if (FrameUtils.alreadyHalted(frame)) {
                return;
            }
        }
        if (FrameUtils.isTopLevelTransaction(frame) && (maybeCalledContract = FrameUtils.proxyUpdaterFor(frame).get(codeAddress)) instanceof ProxyEvmContract) {
            ProxyEvmContract a = (ProxyEvmContract)maybeCalledContract;
            FrameUtils.recordBuilderFor(frame).trackExplicitRewardSituation(a.hederaId());
        }
        frame.setState(MessageFrame.State.CODE_EXECUTING);
    }

    private boolean isTokenCreation(MessageFrame frame) {
        if (frame.getInputData().isEmpty()) {
            return false;
        }
        byte[] selector = frame.getInputData().slice(0, 4).toArray();
        return CreateCommons.createMethodsSet.stream().anyMatch(s -> Arrays.equals(s.selector(), selector));
    }

    public boolean isImplicitCreationEnabled() {
        return this.featureFlags.isImplicitCreationEnabled();
    }

    private void handleNonExtantSystemAccount(@NonNull MessageFrame frame, @NonNull OperationTracer tracer) {
        PrecompiledContract.PrecompileContractResult result = PrecompiledContract.PrecompileContractResult.success((Bytes)Bytes.EMPTY);
        frame.clearGasRemaining();
        this.finishPrecompileExecution(frame, result, ContractActionType.PRECOMPILE, (ActionSidecarContentTracer)tracer);
    }

    private void doExecutePrecompile(@NonNull PrecompiledContract precompile, @NonNull MessageFrame frame, @NonNull OperationTracer tracer) {
        PrecompiledContract.PrecompileContractResult result;
        long gasRequirement = precompile.gasRequirement(frame.getInputData());
        if (frame.getRemainingGas() < gasRequirement) {
            result = PrecompiledContract.PrecompileContractResult.halt((Bytes)Bytes.EMPTY, Optional.of(ExceptionalHaltReason.INSUFFICIENT_GAS));
        } else {
            frame.decrementRemainingGas(gasRequirement);
            OpsDurationCounter opsDurationCounter = FrameUtils.opsDurationCounter(frame);
            OpsDurationSchedule opsDurationSchedule = opsDurationCounter.schedule();
            long opsDurationCost = gasRequirement * opsDurationSchedule.precompileGasBasedDurationMultiplier() / opsDurationSchedule.multipliersDenominator();
            opsDurationCounter.recordOpsDurationUnitsConsumed(opsDurationCost);
            this.contractMetrics.opsDurationMetrics().recordPrecompileOpsDuration(precompile.getName(), opsDurationCost);
            result = precompile.computePrecompile(frame.getInputData(), frame);
            if (result.isRefundGas()) {
                frame.incrementRemainingGas(gasRequirement);
            }
        }
        this.finishPrecompileExecution(frame, result, ContractActionType.PRECOMPILE, (ActionSidecarContentTracer)tracer);
    }

    private void doExecuteSystemContract(@NonNull HederaSystemContract systemContract, @NonNull Address systemContractAddress, @NonNull MessageFrame frame, @NonNull OperationTracer tracer) {
        PrecompiledContract.PrecompileContractResult result;
        FullResult fullResult = systemContract.computeFully(ContractID.newBuilder().contractNum(ConversionUtils.numberOfLongZero(systemContractAddress)).build(), frame.getInputData(), frame);
        long gasRequirement = fullResult.gasRequirement();
        if (frame.getRemainingGas() < gasRequirement) {
            result = PrecompiledContract.PrecompileContractResult.halt((Bytes)Bytes.EMPTY, Optional.of(ExceptionalHaltReason.INSUFFICIENT_GAS));
        } else {
            if (!fullResult.isRefundGas()) {
                frame.decrementRemainingGas(gasRequirement);
            }
            OpsDurationCounter opsDurationCounter = FrameUtils.opsDurationCounter(frame);
            OpsDurationSchedule opsDurationSchedule = opsDurationCounter.schedule();
            long opsDurationCost = gasRequirement * opsDurationSchedule.systemContractGasBasedDurationMultiplier() / opsDurationSchedule.multipliersDenominator();
            opsDurationCounter.recordOpsDurationUnitsConsumed(opsDurationCost);
            this.contractMetrics.opsDurationMetrics().recordSystemContractOpsDuration(systemContract.getName(), systemContractAddress.toHexString(), opsDurationCost);
            result = fullResult.result();
        }
        this.finishPrecompileExecution(frame, result, ContractActionType.SYSTEM, (ActionSidecarContentTracer)tracer);
    }

    private void finishPrecompileExecution(@NonNull MessageFrame frame, @NonNull PrecompiledContract.PrecompileContractResult result, @NonNull ContractActionType type, @NonNull ActionSidecarContentTracer tracer) {
        if (result.getState() == MessageFrame.State.REVERT) {
            frame.setRevertReason(result.getOutput());
        } else {
            frame.setOutputData(result.getOutput());
        }
        frame.setState(result.getState());
        frame.setExceptionalHaltReason(result.getHaltReason());
        tracer.tracePrecompileResult(frame, type);
    }

    private void doTransferValueOrHalt(@NonNull MessageFrame frame, @NonNull OperationTracer operationTracer) {
        Optional<ExceptionalHaltReason> maybeReasonToHalt;
        ProxyWorldUpdater proxyWorldUpdater = (ProxyWorldUpdater)frame.getWorldUpdater();
        if (!this.addressChecks.isPresent(frame.getRecipientAddress(), frame)) {
            maybeReasonToHalt = proxyWorldUpdater.tryLazyCreation(frame.getRecipientAddress(), frame);
            maybeReasonToHalt.ifPresent(reason -> this.doHaltOnFailedLazyCreation(frame, (ExceptionalHaltReason)reason, operationTracer));
        }
        if (!FrameUtils.alreadyHalted(frame)) {
            maybeReasonToHalt = proxyWorldUpdater.tryTransfer(frame.getSenderAddress(), frame.getRecipientAddress(), frame.getValue().toLong(), FrameUtils.acquiredSenderAuthorizationViaDelegateCall(frame));
            maybeReasonToHalt.ifPresent(reason -> {
                if (reason == CustomExceptionalHaltReason.INVALID_SIGNATURE) {
                    FrameUtils.setPropagatedCallFailure(frame, HevmPropagatedCallFailure.MISSING_RECEIVER_SIGNATURE);
                }
                this.doHalt(frame, (ExceptionalHaltReason)reason, operationTracer);
            });
        }
    }

    private void doHaltIfInvalidSystemCall(@NonNull MessageFrame frame, @NonNull OperationTracer operationTracer) {
        if (FrameUtils.transfersValue(frame)) {
            this.doHalt(frame, CustomExceptionalHaltReason.INVALID_CONTRACT_ID, operationTracer);
        }
    }

    private void doHaltOnFailedLazyCreation(@NonNull MessageFrame frame, @NonNull ExceptionalHaltReason reason, @NonNull OperationTracer tracer) {
        this.doHalt(frame, reason, tracer, ForLazyCreation.YES);
    }

    private void doHalt(@NonNull MessageFrame frame, @NonNull ExceptionalHaltReason reason, @NonNull OperationTracer tracer) {
        this.doHalt(frame, reason, tracer, ForLazyCreation.NO);
    }

    private void doHalt(@NonNull MessageFrame frame, @NonNull ExceptionalHaltReason reason, @Nullable OperationTracer operationTracer, @NonNull ForLazyCreation forLazyCreation) {
        frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
        frame.setExceptionalHaltReason(Optional.of(reason));
        if (forLazyCreation == ForLazyCreation.YES) {
            frame.decrementRemainingGas(frame.getRemainingGas());
            if (reason == CustomExceptionalHaltReason.INSUFFICIENT_CHILD_RECORDS) {
                FrameUtils.setPropagatedCallFailure(frame, HevmPropagatedCallFailure.RESULT_CANNOT_BE_EXTERNALIZED);
            }
        }
        if (operationTracer != null) {
            if (forLazyCreation == ForLazyCreation.YES) {
                operationTracer.traceAccountCreationResult(frame, Optional.of(reason));
            } else {
                operationTracer.tracePostExecution(frame, new Operation.OperationResult(frame.getRemainingGas(), reason));
            }
        }
    }

    private static enum ForLazyCreation {
        YES,
        NO;

    }
}

