/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.signschedule;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.SignaturePair;
import com.hedera.hapi.node.scheduled.ScheduleSignTransactionBody;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.DispatchForResponseCodeHssCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.app.service.contract.impl.utils.SignatureMapUtils;
import com.hedera.node.app.service.contract.impl.utils.SystemContractUtils;
import com.hedera.node.app.spi.signatures.SignatureVerifier;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class SignScheduleTranslator
extends AbstractCallTranslator<HssCallAttempt> {
    public static final SystemContractMethod SIGN_SCHEDULE = SystemContractMethod.declare("signSchedule(address,bytes)", "(int64)").withCategories(SystemContractMethod.Category.SCHEDULE);
    private static final int SCHEDULE_ID_INDEX = 0;
    private static final int SIGNATURE_MAP_INDEX = 1;
    public static final SystemContractMethod SIGN_SCHEDULE_PROXY = SystemContractMethod.declare("signSchedule()", "(int64)").withVia(SystemContractMethod.CallVia.PROXY).withCategories(SystemContractMethod.Category.SCHEDULE);
    public static final SystemContractMethod AUTHORIZE_SCHEDULE = SystemContractMethod.declare("authorizeSchedule(address)", "(int64)").withCategories(SystemContractMethod.Category.SCHEDULE);

    @Inject
    public SignScheduleTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HSS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(SIGN_SCHEDULE, AUTHORIZE_SCHEDULE, SIGN_SCHEDULE_PROXY);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HssCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        boolean signScheduleEnabled = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractSignScheduleEnabled();
        boolean signScheduleFromContractEnabled = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractSignScheduleFromContractEnabled();
        boolean authorizeScheduleEnabled = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractAuthorizeScheduleEnabled();
        if (attempt.isSelectorIfConfigEnabled(signScheduleEnabled, SIGN_SCHEDULE_PROXY)) {
            return Optional.of(SIGN_SCHEDULE_PROXY);
        }
        if (attempt.isSelectorIfConfigEnabled(authorizeScheduleEnabled, AUTHORIZE_SCHEDULE)) {
            return Optional.of(AUTHORIZE_SCHEDULE);
        }
        if (attempt.isSelectorIfConfigEnabled(signScheduleFromContractEnabled, SIGN_SCHEDULE)) {
            return Optional.of(SIGN_SCHEDULE);
        }
        return Optional.empty();
    }

    @Override
    public Call callFrom(@NonNull HssCallAttempt attempt) {
        TransactionBody body = this.bodyFor(this.scheduleIdFor(attempt));
        return new DispatchForResponseCodeHssCall(attempt, body, SignScheduleTranslator::gasRequirement, this.keySetFor(attempt));
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.SCHEDULE_SIGN, payerId);
    }

    @VisibleForTesting
    public TransactionBody bodyFor(@NonNull ScheduleID scheduleID) {
        Objects.requireNonNull(scheduleID);
        return TransactionBody.newBuilder().scheduleSign(ScheduleSignTransactionBody.newBuilder().scheduleID(scheduleID).build()).build();
    }

    @VisibleForTesting
    public ScheduleID scheduleIdFor(@NonNull HssCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        if (attempt.isSelector(SIGN_SCHEDULE_PROXY)) {
            return SignScheduleTranslator.getScheduleIDForSignScheduleProxy(attempt);
        }
        if (attempt.isSelector(SIGN_SCHEDULE)) {
            return SignScheduleTranslator.getScheduleIDForSignSchedule(attempt);
        }
        if (attempt.isSelector(AUTHORIZE_SCHEDULE)) {
            return SignScheduleTranslator.getScheduleIDForAuthorizeSchedule(attempt);
        }
        throw new IllegalStateException("Unexpected function selector");
    }

    private static ScheduleID getScheduleIDForSignSchedule(@NonNull HssCallAttempt attempt) {
        Tuple call = SIGN_SCHEDULE.decodeCall(attempt.inputBytes());
        return SignScheduleTranslator.getScheduleIDFromCall(attempt, call);
    }

    private static ScheduleID getScheduleIDForAuthorizeSchedule(@NonNull HssCallAttempt attempt) {
        Tuple call = AUTHORIZE_SCHEDULE.decodeCall(attempt.inputBytes());
        return SignScheduleTranslator.getScheduleIDFromCall(attempt, call);
    }

    @Nullable
    private static ScheduleID getScheduleIDFromCall(@NonNull HssCallAttempt attempt, Tuple call) {
        Address scheduleAddress = (Address)call.get(0);
        long number = ConversionUtils.numberOfLongZero(ConversionUtils.explicitFromHeadlong(scheduleAddress));
        Schedule schedule = attempt.nativeOperations().getSchedule(attempt.nativeOperations().entityIdFactory().newScheduleId(number));
        HandleException.validateTrue((schedule != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_SCHEDULE_ID);
        return schedule.scheduleId();
    }

    private static ScheduleID getScheduleIDForSignScheduleProxy(@NonNull HssCallAttempt attempt) {
        ScheduleID scheduleID = attempt.redirectScheduleId();
        HandleException.validateTrue((scheduleID != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_SCHEDULE_ID);
        return attempt.redirectScheduleId();
    }

    private Set<Key> keySetFor(@NonNull HssCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        if (attempt.isSelector(SIGN_SCHEDULE)) {
            return SignScheduleTranslator.getKeyForSignSchedule(attempt);
        }
        return attempt.keySetFor();
    }

    @VisibleForTesting
    @NonNull
    public static Set<Key> getKeyForSignSchedule(@NonNull HssCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        HashSet<Key> keys = new HashSet<Key>();
        Tuple call = SIGN_SCHEDULE.decodeCall(attempt.inputBytes());
        ScheduleID scheduleId = Objects.requireNonNull(SignScheduleTranslator.getScheduleIDFromCall(attempt, call));
        Bytes message = SystemContractUtils.messageFromScheduleId(scheduleId);
        byte[] signatureBlob = (byte[])call.get(1);
        try {
            int chainId = ((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).chainId();
            SignatureMap sigMap = SignatureMapUtils.preprocessEcdsaSignatures(Objects.requireNonNull((SignatureMap)SignatureMap.PROTOBUF.parse(Bytes.wrap((byte[])signatureBlob))), chainId);
            for (SignaturePair sigPair : sigMap.sigPair()) {
                Key key;
                if (sigPair.hasEd25519() && SignScheduleTranslator.isVerifiedSignature(attempt, key = Key.newBuilder().ed25519(sigPair.pubKeyPrefix()).build(), message, sigMap)) {
                    keys.add(key);
                }
                if (!sigPair.hasEcdsaSecp256k1() || !SignScheduleTranslator.isVerifiedSignature(attempt, key = Key.newBuilder().ecdsaSecp256k1(sigPair.pubKeyPrefix()).build(), message, sigMap)) continue;
                keys.add(key);
            }
        }
        catch (ParseException | IllegalArgumentException | NullPointerException ex) {
            throw new HandleException(ResponseCodeEnum.INVALID_TRANSACTION_BODY);
        }
        return keys;
    }

    private static boolean isVerifiedSignature(@NonNull HssCallAttempt attempt, Key key, Bytes message, SignatureMap sigMap) {
        return attempt.signatureVerifier().verifySignature(key, message, SignatureVerifier.MessageType.RAW, sigMap, ky -> SignatureVerifier.SimpleKeyStatus.ONLY_IF_CRYPTO_SIG_VALID);
    }
}

