/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.fees.usage.crypto;

import com.hederahashgraph.api.proto.java.SubType;

public class CryptoTransferMeta {
    private int tokenMultiplier = 1;
    private final int numTokensInvolved;
    private final int numFungibleTokenTransfers;
    private final int numNftOwnershipChanges;
    private int customFeeTokensInvolved;
    private int customFeeHbarTransfers;
    private int customFeeTokenTransfers;

    public CryptoTransferMeta(int tokenMultiplier, int numTokensInvolved, int numFungibleTokenTransfers, int numNftOwnershipChanges) {
        this.tokenMultiplier = tokenMultiplier;
        this.numTokensInvolved = numTokensInvolved;
        this.numFungibleTokenTransfers = numFungibleTokenTransfers;
        this.numNftOwnershipChanges = numNftOwnershipChanges;
    }

    public int getTokenMultiplier() {
        return this.tokenMultiplier;
    }

    public int getNumTokensInvolved() {
        return this.numTokensInvolved;
    }

    public int getNumFungibleTokenTransfers() {
        return this.numFungibleTokenTransfers;
    }

    public void setTokenMultiplier(int tokenMultiplier) {
        this.tokenMultiplier = tokenMultiplier;
    }

    public void setCustomFeeTokensInvolved(int customFeeTokensInvolved) {
        this.customFeeTokensInvolved = customFeeTokensInvolved;
    }

    public int getCustomFeeTokensInvolved() {
        return this.customFeeTokensInvolved;
    }

    public void setCustomFeeTokenTransfers(int customFeeTokenTransfers) {
        this.customFeeTokenTransfers = customFeeTokenTransfers;
    }

    public int getCustomFeeTokenTransfers() {
        return this.customFeeTokenTransfers;
    }

    public void setCustomFeeHbarTransfers(int customFeeHbarTransfers) {
        this.customFeeHbarTransfers = customFeeHbarTransfers;
    }

    public int getCustomFeeHbarTransfers() {
        return this.customFeeHbarTransfers;
    }

    public int getNumNftOwnershipChanges() {
        return this.numNftOwnershipChanges;
    }

    public SubType getSubType() {
        if (this.numNftOwnershipChanges != 0) {
            if (this.customFeeHbarTransfers > 0 || this.customFeeTokenTransfers > 0) {
                return SubType.TOKEN_NON_FUNGIBLE_UNIQUE_WITH_CUSTOM_FEES;
            }
            return SubType.TOKEN_NON_FUNGIBLE_UNIQUE;
        }
        if (this.numFungibleTokenTransfers != 0) {
            if (this.customFeeHbarTransfers > 0 || this.customFeeTokenTransfers > 0) {
                return SubType.TOKEN_FUNGIBLE_COMMON_WITH_CUSTOM_FEES;
            }
            return SubType.TOKEN_FUNGIBLE_COMMON;
        }
        return SubType.DEFAULT;
    }
}

