/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPairGenerator;
import java.security.Provider;
import java.security.Security;
import java.security.spec.ECGenParameterSpec;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.units.bigints.UInt256;
import org.bouncycastle.asn1.sec.SECNamedCurves;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.crypto.signers.DSAKCalculator;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.jcajce.provider.asymmetric.ec.KeyPairGeneratorSpi;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.math.ec.ECAlgorithms;
import org.bouncycastle.math.ec.ECPoint;
import org.hyperledger.besu.crypto.KeyPair;
import org.hyperledger.besu.crypto.SECPPrivateKey;
import org.hyperledger.besu.crypto.SECPPublicKey;
import org.hyperledger.besu.crypto.SECPSignature;
import org.hyperledger.besu.crypto.SecureRandomProvider;
import org.hyperledger.besu.crypto.SignatureAlgorithm;

public abstract class AbstractSECP256
implements SignatureAlgorithm {
    public static final String PROVIDER = "BC";
    protected final ECDomainParameters curve;
    protected final BigInteger halfCurveOrder;
    protected final KeyPairGenerator keyPairGenerator;
    protected final BigInteger curveOrder;
    final BigInteger prime;

    protected AbstractSECP256(String curveName, BigInteger prime) {
        this.prime = prime;
        Security.addProvider((Provider)new BouncyCastleProvider());
        X9ECParameters params = SECNamedCurves.getByName((String)curveName);
        this.curve = new ECDomainParameters(params.getCurve(), params.getG(), params.getN(), params.getH());
        this.curveOrder = this.curve.getN();
        this.halfCurveOrder = this.curveOrder.shiftRight(1);
        try {
            this.keyPairGenerator = new KeyPairGeneratorSpi.ECDSA();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ECGenParameterSpec ecGenParameterSpec = new ECGenParameterSpec(curveName);
        try {
            this.keyPairGenerator.initialize(ecGenParameterSpec, SecureRandomProvider.createSecureRandom());
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SECPSignature normaliseSignature(BigInteger nativeR, BigInteger nativeS, SECPPublicKey publicKey, Bytes32 dataHash) {
        BigInteger s = nativeS;
        if (s.compareTo(this.halfCurveOrder) > 0) {
            s = this.curve.getN().subtract(s);
        }
        int recId = -1;
        BigInteger publicKeyBI = publicKey.getEncodedBytes().toUnsignedBigInteger();
        for (int i = 0; i < 4; ++i) {
            BigInteger k = this.recoverFromSignature(i, nativeR, s, dataHash);
            if (k == null || !k.equals(publicKeyBI)) continue;
            recId = i;
            break;
        }
        if (recId == -1) {
            throw new RuntimeException("Could not construct a recoverable key. This should never happen.");
        }
        return new SECPSignature(nativeR, s, (byte)recId);
    }

    @Override
    public Bytes32 calculateECDHKeyAgreement(SECPPrivateKey privKey, SECPPublicKey theirPubKey) {
        Preconditions.checkArgument((privKey != null ? 1 : 0) != 0, (Object)"missing private key");
        Preconditions.checkArgument((theirPubKey != null ? 1 : 0) != 0, (Object)"missing remote public key");
        ECPrivateKeyParameters privKeyP = new ECPrivateKeyParameters(privKey.getD(), this.curve);
        ECPublicKeyParameters pubKeyP = new ECPublicKeyParameters(theirPubKey.asEcPoint(this.curve), this.curve);
        ECDHBasicAgreement agreement = new ECDHBasicAgreement();
        agreement.init((CipherParameters)privKeyP);
        BigInteger agreed = agreement.calculateAgreement((CipherParameters)pubKeyP);
        return UInt256.valueOf((BigInteger)agreed);
    }

    @Override
    public SECPPrivateKey createPrivateKey(BigInteger key) {
        return SECPPrivateKey.create(key, "ECDSA");
    }

    @Override
    public SECPPrivateKey createPrivateKey(Bytes32 key) {
        return SECPPrivateKey.create(key, "ECDSA");
    }

    @Override
    public SECPPublicKey createPublicKey(SECPPrivateKey privateKey) {
        return SECPPublicKey.create(privateKey, this.curve, "ECDSA");
    }

    @Override
    public SECPPublicKey createPublicKey(BigInteger key) {
        return SECPPublicKey.create(key, "ECDSA");
    }

    @Override
    public SECPPublicKey createPublicKey(Bytes encoded) {
        return SECPPublicKey.create(encoded, "ECDSA");
    }

    @Override
    public ECPoint publicKeyAsEcPoint(SECPPublicKey publicKey) {
        return publicKey.asEcPoint(this.curve);
    }

    @Override
    public boolean isValidPublicKey(SECPPublicKey publicKey) {
        try {
            this.publicKeyAsEcPoint(publicKey);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return true;
    }

    @Override
    public KeyPair createKeyPair(SECPPrivateKey privateKey) {
        return KeyPair.create(privateKey, this.curve, "ECDSA");
    }

    @Override
    public KeyPair generateKeyPair() {
        return KeyPair.generate(this.keyPairGenerator, "ECDSA");
    }

    @Override
    public SECPSignature createSignature(BigInteger r, BigInteger s, byte recId) {
        return SECPSignature.create(r, s, recId, this.curveOrder);
    }

    @Override
    public SECPSignature decodeSignature(Bytes bytes) {
        return SECPSignature.decode(bytes, this.curveOrder);
    }

    @Override
    public BigInteger getHalfCurveOrder() {
        return this.halfCurveOrder;
    }

    @Override
    public String getProvider() {
        return PROVIDER;
    }

    public abstract DSAKCalculator getKCalculator();

    protected ECPoint decompressKey(BigInteger xBN, boolean yBit) {
        X9IntegerConverter x9 = new X9IntegerConverter();
        byte[] compEnc = x9.integerToBytes(xBN, 1 + x9.getByteLength(this.curve.getCurve()));
        compEnc[0] = (byte)(yBit ? 3 : 2);
        return this.curve.getCurve().decodePoint(compEnc);
    }

    protected BigInteger recoverFromSignature(int recId, BigInteger r, BigInteger s, Bytes32 dataHash) {
        assert (recId >= 0);
        assert (r.signum() >= 0);
        assert (s.signum() >= 0);
        assert (dataHash != null);
        BigInteger n = this.curve.getN();
        BigInteger i = BigInteger.valueOf((long)recId / 2L);
        BigInteger x = r.add(i.multiply(n));
        if (x.compareTo(this.prime) >= 0) {
            return null;
        }
        ECPoint R = this.decompressKey(x, (recId & 1) == 1);
        if (!R.multiply(n).isInfinity()) {
            return null;
        }
        BigInteger e = dataHash.toUnsignedBigInteger();
        BigInteger eInv = BigInteger.ZERO.subtract(e).mod(n);
        BigInteger rInv = r.modInverse(n);
        BigInteger srInv = rInv.multiply(s).mod(n);
        BigInteger eInvrInv = rInv.multiply(eInv).mod(n);
        ECPoint q = ECAlgorithms.sumOfTwoMultiplies((ECPoint)this.curve.getG(), (BigInteger)eInvrInv, (ECPoint)R, (BigInteger)srInv);
        if (q.isInfinity()) {
            return null;
        }
        byte[] qBytes = q.getEncoded(false);
        return new BigInteger(1, Arrays.copyOfRange(qBytes, 1, qBytes.length));
    }

    @Override
    public SECPSignature sign(Bytes32 dataHash, KeyPair keyPair) {
        ECDSASigner signer = new ECDSASigner(this.getKCalculator());
        ECPrivateKeyParameters privKey = new ECPrivateKeyParameters(keyPair.getPrivateKey().getEncodedBytes().toUnsignedBigInteger(), this.curve);
        signer.init(true, (CipherParameters)privKey);
        BigInteger[] components = signer.generateSignature(dataHash.toArrayUnsafe());
        return this.normaliseSignature(components[0], components[1], keyPair.getPublicKey(), dataHash);
    }

    @Override
    public boolean verify(Bytes data, SECPSignature signature, SECPPublicKey pub) {
        ECDSASigner signer = new ECDSASigner();
        Bytes toDecode = Bytes.wrap((Bytes[])new Bytes[]{Bytes.of((byte[])new byte[]{4}), pub.getEncodedBytes()});
        ECPublicKeyParameters params = new ECPublicKeyParameters(this.curve.getCurve().decodePoint(toDecode.toArrayUnsafe()), this.curve);
        signer.init(false, (CipherParameters)params);
        try {
            return signer.verifySignature(data.toArrayUnsafe(), signature.getR(), signature.getS());
        }
        catch (NullPointerException e) {
            return false;
        }
    }

    @Override
    public boolean verify(Bytes data, SECPSignature signature, SECPPublicKey pub, UnaryOperator<Bytes> preprocessor) {
        Preconditions.checkArgument((preprocessor != null ? 1 : 0) != 0, (Object)"preprocessor must not be null");
        return this.verify((Bytes)preprocessor.apply(data), signature, pub);
    }

    @Override
    public Optional<SECPPublicKey> recoverPublicKeyFromSignature(Bytes32 dataHash, SECPSignature signature) {
        BigInteger publicKeyBI = this.recoverFromSignature(signature.getRecId(), signature.getR(), signature.getS(), dataHash);
        return Optional.of(SECPPublicKey.create(publicKeyBI, "ECDSA"));
    }

    @Override
    public Bytes compressPublicKey(SECPPublicKey uncompressedPublicKey) {
        return Bytes.wrap((byte[])this.publicKeyAsEcPoint(uncompressedPublicKey).getEncoded(true));
    }
}

