/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.metadata.hson;

import io.helidon.common.buffers.BufferData;
import io.helidon.common.buffers.DataReader;
import io.helidon.metadata.hson.Hson;
import io.helidon.metadata.hson.HsonException;
import io.helidon.metadata.hson.HsonValues;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;

class HsonParser {
    private static final int MAX_FIELD_LENGTH = 64000;
    private static final byte COMMA = 44;
    private static final byte QUOTES = 34;
    private static final byte ARRAY_START = 91;
    private static final byte ARRAY_END = 93;
    private static final byte STRUCT_START = 123;
    private static final byte STRUCT_END = 125;
    private static final byte BACKSLASH = 92;
    private final DataReader reader;
    private int position;

    private HsonParser(DataReader reader) {
        this.reader = reader;
    }

    static Hson.Value<?> parse(InputStream stream) {
        DataReader dr = new DataReader(() -> {
            byte[] buffer = new byte[1024];
            try {
                int num = stream.read(buffer);
                if (num > 0) {
                    return buffer;
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return null;
        });
        return new HsonParser(dr).read(true);
    }

    private Hson.Value<?> read(boolean topLevel) {
        byte next = this.skipWhitespace();
        if (next == 91) {
            return this.readArray();
        }
        if (next == 123) {
            return this.readStruct();
        }
        if (topLevel) {
            throw new HsonException("Index: " + this.position + ": failed to parse HSON, invalid struct/array opening character: \n" + BufferData.create((byte[])new byte[]{next}).debugDataHex());
        }
        if (next == 34) {
            return this.readString("Struct");
        }
        return this.readValue();
    }

    private Hson.Value<?> readArray() {
        byte next;
        this.skip();
        ArrayList<Hson.Value<Hson.Struct>> values = new ArrayList<Hson.Value<Hson.Struct>>();
        while (true) {
            if ((next = this.skipWhitespace()) == 93) {
                this.skip();
                return Hson.Array.create(values);
            }
            Hson.Value<Object> value = switch (next) {
                case 123 -> this.readStruct();
                case 91 -> this.readArray();
                case 34 -> this.readString("Array");
                default -> this.readValue();
            };
            values.add(value);
            next = this.skipWhitespace();
            if (next != 44) break;
            this.skip();
        }
        next = this.skipWhitespace();
        if (next == 93) {
            this.skip();
            return Hson.Array.create(values);
        }
        throw new HsonException("Index: " + this.position + ": value not followed by a comma, and array does not end");
    }

    private Hson.Value<Hson.Struct> readStruct() {
        String key;
        byte next;
        this.skip();
        Hson.Struct.Builder struct = Hson.Struct.builder();
        while (true) {
            if ((next = this.skipWhitespace()) == 125) {
                this.skip();
                return (Hson.Value)struct.build();
            }
            key = this.readKey();
            this.skipWhitespace();
            next = this.read();
            if (next != 58) {
                throw new HsonException("Index: " + this.position + ": key is not followed by a colon. Key: " + BufferData.create((String)key).debugDataHex());
            }
            this.skipWhitespace();
            Hson.Value<?> value = this.read(false);
            struct.set(key, value);
            next = this.skipWhitespace();
            if (next != 44) break;
            this.skip();
        }
        next = this.skipWhitespace();
        if (next == 125) {
            this.skip();
            return (Hson.Value)struct.build();
        }
        throw new HsonException("Index: " + this.position + ": value not followed by a comma, and struct does not end. Found: \n" + BufferData.create((byte[])new byte[]{next}).debugDataHex() + ", for key: \n" + BufferData.create((String)key).debugDataHex());
    }

    private String readKey() {
        byte read = this.reader.lookup();
        if (read != 34) {
            throw new HsonException("Index: " + this.position + ": keys must be quoted, invalid beginning of key");
        }
        return this.readString("Key").value();
    }

    private Hson.Value<String> readString(String type) {
        this.skip();
        ByteArrayOutputStream value = new ByteArrayOutputStream();
        boolean escaping = false;
        for (int count = 0; count < 64000; ++count) {
            byte next = this.reader.read();
            if (!escaping && next == 34) {
                return HsonValues.StringValue.create(value.toString(StandardCharsets.UTF_8));
            }
            if (escaping) {
                escaping = false;
                char nextChar = (char)(next & 0xFF);
                if (nextChar == 'u') {
                    String hexadecimalEscape = this.reader.readAsciiString(4);
                    value.write((char)Integer.parseInt(hexadecimalEscape, 16));
                    continue;
                }
                int toWrite = switch (nextChar) {
                    case 'f' -> 12;
                    case 'n' -> 10;
                    case 'r' -> 13;
                    case 't' -> 9;
                    case 'b' -> 8;
                    case '\\' -> 92;
                    case '\"' -> 34;
                    case '/' -> 47;
                    default -> throw new HsonException("Index " + this.position + ": invalid escape char after backslash: '" + nextChar + "'");
                };
                value.write(toWrite);
                continue;
            }
            if (next == 92) {
                escaping = true;
                continue;
            }
            value.write(next);
        }
        throw new HsonException("Index: " + this.position + ": " + type + " failed to find end quotes, or length is bigger than allowed. Max length: 64000 bytes");
    }

    private Hson.Value<?> readValue() {
        String value = this.toNonStringValueEnd();
        if ("true".equals(value) || "false".equals(value)) {
            return HsonValues.BooleanValue.create(Boolean.parseBoolean(value));
        }
        if ("null".equals(value)) {
            return HsonValues.NullValue.INSTANCE;
        }
        try {
            return HsonValues.NumberValue.create(new BigDecimal(value));
        }
        catch (NumberFormatException e) {
            throw new HsonException("Index: " + this.position + ": cannot parse HSON value into a number. Data: " + BufferData.create((String)value).debugDataHex());
        }
    }

    private String toNonStringValueEnd() {
        byte next;
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        while (!this.whitespace(next = this.reader.lookup()) && next != 44 && next != 93 && next != 125) {
            this.skip();
            bo.write(next);
        }
        return bo.toString(StandardCharsets.US_ASCII);
    }

    private byte skipWhitespace() {
        byte lookup;
        while (this.whitespace(lookup = this.reader.lookup())) {
            this.skip();
        }
        return lookup;
    }

    private boolean whitespace(byte lookup) {
        return switch (lookup) {
            case 9, 10, 13, 32 -> true;
            default -> false;
        };
    }

    private void skip() {
        this.reader.skip(1);
        ++this.position;
    }

    private byte read() {
        byte r = this.reader.read();
        ++this.position;
        return r;
    }
}

