/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.AbstractFixedCostOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class ShlOperation
extends AbstractFixedCostOperation {
    static final Operation.OperationResult shlSuccess = new Operation.OperationResult(3L, null);

    public ShlOperation(GasCalculator gasCalculator) {
        super(27, "SHL", 2, 1, gasCalculator, gasCalculator.getVeryLowTierGasCost());
    }

    @Override
    public Operation.OperationResult executeFixedCostOperation(MessageFrame frame, EVM evm) {
        return ShlOperation.staticOperation(frame);
    }

    public static Operation.OperationResult staticOperation(MessageFrame frame) {
        Bytes shiftAmount = frame.popStackItem();
        if (shiftAmount.size() > 4 && (shiftAmount = shiftAmount.trimLeadingZeros()).size() > 4) {
            frame.popStackItem();
            frame.pushStackItem(Bytes.EMPTY);
        } else {
            int shiftAmountInt = shiftAmount.toInt();
            Bytes32 value = Bytes32.leftPad((Bytes)frame.popStackItem());
            if (shiftAmountInt >= 256 || shiftAmountInt < 0) {
                frame.pushStackItem(Bytes.EMPTY);
            } else {
                frame.pushStackItem(value.shiftLeft(shiftAmountInt));
            }
        }
        return shlSuccess;
    }
}

