/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.math.BigInteger;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.BaseUInt64Value;
import org.apache.tuweni.units.bigints.UInt64;
import org.hyperledger.besu.datatypes.Quantity;

public final class BlobGas
extends BaseUInt64Value<BlobGas>
implements Quantity {
    public static final BlobGas ZERO = BlobGas.of(0L);
    public static final BlobGas ONE = BlobGas.of(1L);
    public static final BlobGas MAX_BLOB_GAS = BlobGas.of(UInt64.MAX_VALUE);

    BlobGas(UInt64 value) {
        super(value, BlobGas::new);
    }

    private BlobGas(long v) {
        this(UInt64.valueOf((long)v));
    }

    private BlobGas(BigInteger v) {
        this(UInt64.valueOf((BigInteger)v));
    }

    private BlobGas(String hexString) {
        this(UInt64.fromHexString((String)hexString));
    }

    public static BlobGas of(long value) {
        return new BlobGas(value);
    }

    public static BlobGas of(BigInteger value) {
        return new BlobGas(value);
    }

    public static BlobGas of(UInt64 value) {
        return new BlobGas(value);
    }

    public static BlobGas ofNumber(Number value) {
        return new BlobGas((BigInteger)value);
    }

    public static BlobGas wrap(Bytes value) {
        return new BlobGas(UInt64.fromBytes((Bytes)value));
    }

    public static BlobGas fromHexString(String str) {
        return new BlobGas(str);
    }

    @Override
    public Number getValue() {
        return this.getAsBigInteger();
    }

    @Override
    public BigInteger getAsBigInteger() {
        return this.toBigInteger();
    }

    @Override
    public String toHexString() {
        return super.toHexString();
    }

    @Override
    public String toShortHexString() {
        return super.isZero() ? "0x0" : super.toShortHexString();
    }

    public static BlobGas fromQuantity(Quantity quantity) {
        return BlobGas.wrap((Bytes)quantity);
    }
}

