/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.tracers;

import com.hedera.hapi.streams.ContractAction;
import com.hedera.hapi.streams.ContractActionType;
import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.tracers.EvmActionTracer;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.datatypes.Transaction;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.log.Log;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.tracing.OperationTracer;
import org.hyperledger.besu.evm.worldstate.WorldView;

public class AddOnEvmActionTracer
implements ActionSidecarContentTracer {
    private final EvmActionTracer evmActionTracer;
    private final List<OperationTracer> addOnTracers;

    public AddOnEvmActionTracer(@NonNull EvmActionTracer evmActionTracer, @NonNull List<OperationTracer> addOnTracers) {
        this.evmActionTracer = Objects.requireNonNull(evmActionTracer);
        this.addOnTracers = Objects.requireNonNull(addOnTracers);
    }

    @Override
    public void traceOriginAction(@NonNull MessageFrame frame) {
        this.evmActionTracer.traceOriginAction(frame);
    }

    @Override
    public void sanitizeTracedActions(@NonNull MessageFrame frame) {
        this.evmActionTracer.sanitizeTracedActions(frame);
    }

    @Override
    public void tracePrecompileResult(@NonNull MessageFrame frame, @NonNull ContractActionType type) {
        this.evmActionTracer.tracePrecompileResult(frame, type);
    }

    @Override
    @NonNull
    public List<ContractAction> contractActions() {
        return this.evmActionTracer.contractActions();
    }

    public void tracePostExecution(@NonNull MessageFrame frame, @NonNull Operation.OperationResult operationResult) {
        this.evmActionTracer.tracePostExecution(frame, operationResult);
        this.addOnTracers.forEach(tracer -> tracer.tracePostExecution(frame, operationResult));
    }

    public void traceAccountCreationResult(@NonNull MessageFrame frame, @NonNull Optional<ExceptionalHaltReason> haltReason) {
        this.evmActionTracer.traceAccountCreationResult(frame, haltReason);
        this.addOnTracers.forEach(tracer -> tracer.traceAccountCreationResult(frame, haltReason));
    }

    public void tracePreExecution(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        this.addOnTracers.forEach(tracer -> tracer.tracePreExecution(frame));
    }

    public void tracePrecompileCall(@NonNull MessageFrame frame, long gasRequirement, @Nullable Bytes output) {
        Objects.requireNonNull(frame);
        this.addOnTracers.forEach(tracer -> tracer.tracePrecompileCall(frame, gasRequirement, output));
    }

    public void tracePrepareTransaction(@NonNull WorldView worldView, @NonNull Transaction transaction) {
        Objects.requireNonNull(worldView);
        Objects.requireNonNull(transaction);
        this.addOnTracers.forEach(tracer -> tracer.tracePrepareTransaction(worldView, transaction));
    }

    public void traceStartTransaction(@NonNull WorldView worldView, @NonNull Transaction transaction) {
        Objects.requireNonNull(worldView);
        Objects.requireNonNull(transaction);
        this.addOnTracers.forEach(tracer -> tracer.traceStartTransaction(worldView, transaction));
    }

    public void traceEndTransaction(@NonNull WorldView worldView, @NonNull Transaction tx, boolean status, @Nullable Bytes output, @NonNull List<Log> logs, long gasUsed, long timeNs) {
        Objects.requireNonNull(worldView);
        Objects.requireNonNull(tx);
        Objects.requireNonNull(logs);
        this.addOnTracers.forEach(tracer -> tracer.traceEndTransaction(worldView, tx, status, output, logs, gasUsed, timeNs));
    }

    public void traceContextEnter(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        this.addOnTracers.forEach(tracer -> tracer.traceContextEnter(frame));
    }

    public void traceContextReEnter(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        this.addOnTracers.forEach(tracer -> tracer.traceContextReEnter(frame));
    }

    public void traceContextExit(@NonNull MessageFrame frame) {
        Objects.requireNonNull(frame);
        this.addOnTracers.forEach(tracer -> tracer.traceContextExit(frame));
    }

    public boolean isExtendedTracing() {
        return this.addOnTracers.stream().anyMatch(OperationTracer::isExtendedTracing);
    }
}

