/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.crypto;

import com.google.common.base.Preconditions;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.MutableBytes;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.math.ec.FixedPointCombMultiplier;
import org.hyperledger.besu.crypto.SECPPrivateKey;

public class SECPPublicKey
implements PublicKey {
    public static final int BYTE_LENGTH = 64;
    private final Bytes encoded;
    private final String algorithm;

    public static SECPPublicKey create(BigInteger key, String algorithm) {
        Preconditions.checkNotNull((Object)key);
        return SECPPublicKey.create(SECPPublicKey.toBytes64(key.toByteArray()), algorithm);
    }

    public static SECPPublicKey create(Bytes encoded, String algorithm) {
        return new SECPPublicKey(encoded, algorithm);
    }

    public static SECPPublicKey create(SECPPrivateKey privateKey, ECDomainParameters curve, String algorithm) {
        BigInteger privKey = privateKey.getEncodedBytes().toUnsignedBigInteger();
        if (privKey.bitLength() > curve.getN().bitLength()) {
            privKey = privKey.mod(curve.getN());
        }
        ECPoint point = new FixedPointCombMultiplier().multiply(curve.getG(), privKey);
        return SECPPublicKey.create(Bytes.wrap((byte[])Arrays.copyOfRange(point.getEncoded(false), 1, 65)), algorithm);
    }

    private static Bytes toBytes64(byte[] backing) {
        if (backing.length == 64) {
            return Bytes.wrap((byte[])backing);
        }
        if (backing.length > 64) {
            return Bytes.wrap((byte[])backing, (int)(backing.length - 64), (int)64);
        }
        MutableBytes res = MutableBytes.create((int)64);
        Bytes.wrap((byte[])backing).copyTo(res, 64 - backing.length);
        return res;
    }

    private SECPPublicKey(Bytes encoded, String algorithm) {
        Preconditions.checkNotNull((Object)encoded);
        Preconditions.checkNotNull((Object)algorithm);
        Preconditions.checkArgument((encoded.size() == 64 ? 1 : 0) != 0, (String)"Encoding must be %s bytes long, got %s", (int)64, (int)encoded.size());
        this.encoded = encoded;
        this.algorithm = algorithm;
    }

    public ECPoint asEcPoint(ECDomainParameters curve) {
        Bytes val = Bytes.concatenate((Bytes[])new Bytes[]{Bytes.of((int[])new int[]{4}), this.encoded});
        return curve.getCurve().decodePoint(val.toArrayUnsafe());
    }

    public boolean equals(Object other) {
        if (!(other instanceof SECPPublicKey)) {
            return false;
        }
        SECPPublicKey that = (SECPPublicKey)other;
        return this.encoded.equals(that.encoded) && this.algorithm.equals(that.algorithm);
    }

    @Override
    public byte[] getEncoded() {
        return this.encoded.toArrayUnsafe();
    }

    public Bytes getEncodedBytes() {
        return this.encoded;
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return null;
    }

    public int hashCode() {
        return this.encoded.hashCode();
    }

    public String toString() {
        return this.encoded.toString();
    }
}

