/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.builder.api.Prototype;
import io.helidon.http.Method;
import io.helidon.http.PathMatcher;
import io.helidon.webserver.ConnectionContext;
import io.helidon.webserver.Routing;
import io.helidon.webserver.http.ErrorHandler;
import io.helidon.webserver.http.Filter;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpFeature;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpRoutingImpl;
import io.helidon.webserver.http.HttpRules;
import io.helidon.webserver.http.HttpSecurity;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.RoutingRequest;
import io.helidon.webserver.http.RoutingResponse;
import io.helidon.webserver.http.ServerRequest;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface HttpRouting
extends Routing,
Prototype.Api {
    public static Builder builder() {
        return HttpRoutingImpl.builder();
    }

    public static HttpRouting create() {
        return (HttpRouting)HttpRouting.builder().route(HttpRoute.builder().handler((req, res) -> res.send("Helidon WebServer works!")).build()).build();
    }

    public static HttpRouting empty() {
        return HttpRoutingImpl.empty();
    }

    @Override
    default public Class<? extends Routing> routingType() {
        return HttpRouting.class;
    }

    public void route(ConnectionContext var1, RoutingRequest var2, RoutingResponse var3);

    public HttpSecurity security();

    public static interface Builder
    extends HttpRules,
    io.helidon.common.Builder<Builder, HttpRouting> {
        @Override
        public Builder register(HttpService ... var1);

        @Override
        default public Builder register(Supplier<? extends HttpService> service) {
            HttpRules.super.register(service);
            return this;
        }

        @Override
        default public Builder register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2) {
            HttpRules.super.register(service1, service2);
            return this;
        }

        @Override
        default public Builder register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3) {
            HttpRules.super.register(service1, service2, service3);
            return this;
        }

        @Override
        default public Builder register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4) {
            HttpRules.super.register(service1, service2, service3, service4);
            return this;
        }

        @Override
        default public Builder register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4, Supplier<? extends HttpService> service5) {
            HttpRules.super.register(service1, service2, service3, service4, service5);
            return this;
        }

        @Override
        default public Builder register(List<Supplier<? extends HttpService>> services) {
            HttpRules.super.register(services);
            return this;
        }

        @Override
        public Builder register(String var1, HttpService ... var2);

        @Override
        default public Builder register(String pathPattern, Supplier<? extends HttpService> service) {
            HttpRules.super.register(pathPattern, service);
            return this;
        }

        @Override
        default public Builder register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2) {
            HttpRules.super.register(pathPattern, service1, service2);
            return this;
        }

        @Override
        default public Builder register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3) {
            HttpRules.super.register(pathPattern, service1, service2, service3);
            return this;
        }

        @Override
        default public Builder register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4) {
            HttpRules.super.register(pathPattern, service1, service2, service3, service4);
            return this;
        }

        @Override
        default public Builder register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4, Supplier<? extends HttpService> service5) {
            HttpRules.super.register(pathPattern, service1, service2, service3, service4, service5);
            return this;
        }

        @Override
        default public Builder register(String pathPattern, List<Supplier<? extends HttpService>> services) {
            HttpRules.super.register(pathPattern, services);
            return this;
        }

        @Override
        public Builder route(HttpRoute var1);

        @Override
        default public Builder route(Supplier<? extends HttpRoute> route) {
            return this.route(route.get());
        }

        @Override
        default public Builder route(Method method, String pathPattern, Handler handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(handler)));
        }

        @Override
        default public Builder route(Method method, PathMatcher pathMatcher, Handler handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().path(pathMatcher).methods(method).handler(handler)));
        }

        @Override
        default public Builder route(Predicate<Method> methodPredicate, PathMatcher pathMatcher, Handler handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().path(pathMatcher).methods(methodPredicate).handler(handler)));
        }

        @Override
        default public Builder route(Method method, Handler handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().methods(method).handler(handler)));
        }

        @Override
        default public Builder get(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.GET, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder get(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.GET, handler);
            }
            return this;
        }

        @Override
        default public Builder post(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.POST, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder post(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.POST, handler);
            }
            return this;
        }

        @Override
        default public Builder put(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.PUT, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder put(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.PUT, handler);
            }
            return this;
        }

        @Override
        default public Builder delete(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.DELETE, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder delete(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.DELETE, handler);
            }
            return this;
        }

        @Override
        default public Builder head(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.HEAD, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder head(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.HEAD, handler);
            }
            return this;
        }

        @Override
        default public Builder options(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.OPTIONS, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder options(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.OPTIONS, handler);
            }
            return this;
        }

        @Override
        default public Builder trace(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.TRACE, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder trace(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.TRACE, handler);
            }
            return this;
        }

        @Override
        default public Builder patch(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.PATCH, pathPattern, handler);
            }
            return this;
        }

        @Override
        default public Builder patch(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route(Method.PATCH, handler);
            }
            return this;
        }

        @Override
        default public Builder any(String pathPattern, Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route((Supplier)((Object)HttpRoute.builder().path(pathPattern).handler(handler)));
            }
            return this;
        }

        @Override
        default public Builder any(Handler ... handlers) {
            for (Handler handler : handlers) {
                this.route((Supplier)((Object)HttpRoute.builder().handler(handler)));
            }
            return this;
        }

        @Override
        default public Builder route(Method method, String pathPattern, Consumer<ServerRequest> handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(Handler.create(handler))));
        }

        @Override
        default public Builder route(Method method, String pathPattern, Function<ServerRequest, ?> handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(Handler.create(handler))));
        }

        @Override
        default public Builder route(Method method, String pathPattern, Supplier<?> handler) {
            return this.route((Supplier)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(Handler.create(handler))));
        }

        public Builder addFilter(Filter var1);

        default public Builder addFeature(HttpFeature feature) {
            return this.addFeature((Supplier<? extends HttpFeature>)feature);
        }

        public Builder addFeature(Supplier<? extends HttpFeature> var1);

        public <T extends Throwable> Builder error(Class<T> var1, ErrorHandler<? super T> var2);

        public Builder maxReRouteCount(int var1);

        public Builder security(HttpSecurity var1);

        public Builder copy();
    }
}

