/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.consensus.impl.handlers;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Duration;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.consensus.ConsensusCreateTopicTransactionBody;
import com.hedera.hapi.node.state.consensus.Topic;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.ConsensusServiceFeeBuilder;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.service.consensus.ReadableTopicStore;
import com.hedera.node.app.service.consensus.impl.WritableTopicStore;
import com.hedera.node.app.service.consensus.impl.records.ConsensusCreateTopicStreamBuilder;
import com.hedera.node.app.service.consensus.impl.validators.ConsensusCustomFeesValidator;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.ids.EntityIdFactory;
import com.hedera.node.app.spi.validation.AttributeValidator;
import com.hedera.node.app.spi.validation.ExpiryMeta;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hedera.node.config.data.TopicsConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.FeeData;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ConsensusCreateTopicHandler
implements TransactionHandler {
    private final EntityIdFactory idFactory;
    private final ConsensusCustomFeesValidator customFeesValidator;

    @Inject
    public ConsensusCreateTopicHandler(@NonNull EntityIdFactory idFactory, @NonNull ConsensusCustomFeesValidator customFeesValidator) {
        this.idFactory = Objects.requireNonNull(idFactory);
        this.customFeesValidator = Objects.requireNonNull(customFeesValidator);
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        ConsensusCreateTopicTransactionBody op = txn.consensusCreateTopicOrThrow();
        long uniqueKeysCount = op.feeExemptKeyList().stream().distinct().count();
        PreCheckException.validateTruePreCheck((uniqueKeysCount == (long)op.feeExemptKeyList().size() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.FEE_EXEMPT_KEY_LIST_CONTAINS_DUPLICATED_KEYS);
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        ConsensusCreateTopicTransactionBody op = context.body().consensusCreateTopicOrThrow();
        if (op.hasAdminKey()) {
            context.requireKeyOrThrow(op.adminKey(), ResponseCodeEnum.BAD_ENCODING);
        }
        if (op.hasAutoRenewAccount()) {
            AccountID autoRenewAccountID = op.autoRenewAccount();
            context.requireKeyOrThrow(autoRenewAccountID, ResponseCodeEnum.INVALID_AUTORENEW_ACCOUNT);
        }
    }

    public void handle(@NonNull HandleContext handleContext) {
        Objects.requireNonNull(handleContext, "The argument 'context' must not be null");
        ConsensusCreateTopicTransactionBody op = handleContext.body().consensusCreateTopicOrThrow();
        WritableTopicStore topicStore = (WritableTopicStore)handleContext.storeFactory().writableStore(WritableTopicStore.class);
        this.validateSemantics(op, handleContext);
        Topic.Builder builder = new Topic.Builder();
        if (op.hasAdminKey() && !AttributeValidator.isImmutableKey((Key)op.adminKey())) {
            builder.adminKey(op.adminKey());
        }
        if (op.hasSubmitKey()) {
            builder.submitKey(op.submitKey());
        }
        if (op.hasFeeScheduleKey()) {
            builder.feeScheduleKey(op.feeScheduleKey());
        }
        builder.feeExemptKeyList(op.feeExemptKeyList());
        builder.customFees(op.customFees());
        builder.memo(op.memo());
        long impliedExpiry = handleContext.consensusNow().getEpochSecond() + op.autoRenewPeriodOrElse(Duration.DEFAULT).seconds();
        ExpiryMeta entityExpiryMeta = new ExpiryMeta(impliedExpiry, op.autoRenewPeriodOrElse(Duration.DEFAULT).seconds(), op.autoRenewAccount());
        try {
            ExpiryMeta effectiveExpiryMeta = handleContext.expiryValidator().resolveCreationAttempt(false, entityExpiryMeta, HederaFunctionality.CONSENSUS_CREATE_TOPIC);
            builder.autoRenewPeriod(effectiveExpiryMeta.autoRenewPeriod());
            builder.expirationSecond(effectiveExpiryMeta.expiry());
            builder.autoRenewAccountId(effectiveExpiryMeta.autoRenewAccountId());
            builder.topicId(this.idFactory.newTopicId(handleContext.entityNumGenerator().newEntityNum()));
            builder.runningHash(Bytes.wrap((byte[])new byte[48]));
            Topic topic = builder.build();
            topicStore.putAndIncrementCount(topic);
            ConsensusCreateTopicStreamBuilder recordBuilder = (ConsensusCreateTopicStreamBuilder)handleContext.savepointStack().getBaseBuilder(ConsensusCreateTopicStreamBuilder.class);
            recordBuilder.topicID(topic.topicId());
        }
        catch (HandleException e) {
            if (e.getStatus() == ResponseCodeEnum.INVALID_EXPIRATION_TIME) {
                throw new HandleException(ResponseCodeEnum.AUTORENEW_DURATION_NOT_IN_RANGE);
            }
            throw e;
        }
    }

    private void validateSemantics(ConsensusCreateTopicTransactionBody op, HandleContext handleContext) {
        Configuration configuration = handleContext.configuration();
        TopicsConfig topicConfig = (TopicsConfig)configuration.getConfigData(TopicsConfig.class);
        ReadableTopicStore topicStore = (ReadableTopicStore)handleContext.storeFactory().readableStore(ReadableTopicStore.class);
        ReadableAccountStore accountStore = (ReadableAccountStore)handleContext.storeFactory().readableStore(ReadableAccountStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)handleContext.storeFactory().readableStore(ReadableTokenStore.class);
        ReadableTokenRelationStore tokenRelStore = (ReadableTokenRelationStore)handleContext.storeFactory().readableStore(ReadableTokenRelationStore.class);
        if (op.hasAdminKey() && !AttributeValidator.isImmutableKey((Key)op.adminKey())) {
            handleContext.attributeValidator().validateKey(op.adminKey());
        }
        if (op.hasSubmitKey()) {
            handleContext.attributeValidator().validateKey(op.submitKey());
        }
        if (op.hasFeeScheduleKey()) {
            handleContext.attributeValidator().validateKey(op.feeScheduleKey(), ResponseCodeEnum.INVALID_CUSTOM_FEE_SCHEDULE_KEY);
        }
        HandleException.validateTrue((op.feeExemptKeyList().size() <= topicConfig.maxEntriesForFeeExemptKeyList() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTRIES_FOR_FEE_EXEMPT_KEY_LIST_EXCEEDED);
        op.feeExemptKeyList().forEach(key -> handleContext.attributeValidator().validateKey(key, ResponseCodeEnum.INVALID_KEY_IN_FEE_EXEMPT_KEY_LIST));
        HandleException.validateTrue((op.customFees().size() <= topicConfig.maxCustomFeeEntriesForTopics() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.CUSTOM_FEES_LIST_TOO_LONG);
        this.customFeesValidator.validate(accountStore, tokenRelStore, tokenStore, op.customFees(), handleContext.expiryValidator());
        HandleException.validateTrue((topicStore.sizeOfState() < topicConfig.maxNumber() ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED);
        handleContext.attributeValidator().validateMemo(op.memo());
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody body = feeContext.body();
        boolean hasCustomFees = !body.consensusCreateTopicOrThrow().customFees().isEmpty();
        SubType subType = hasCustomFees ? SubType.TOPIC_CREATE_WITH_CUSTOM_FEES : SubType.DEFAULT;
        return feeContext.feeCalculatorFactory().feeCalculator(subType).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)body), (SigValueObj)sigValueObj));
    }

    private FeeData usageGiven(com.hederahashgraph.api.proto.java.TransactionBody txn, SigValueObj sigUsage) {
        return ConsensusServiceFeeBuilder.getConsensusCreateTopicFee((com.hederahashgraph.api.proto.java.TransactionBody)txn, (SigValueObj)sigUsage);
    }
}

