/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi;

import com.hedera.node.app.spi.RpcService;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;

public final class RpcServiceFactory {
    private RpcServiceFactory() {
    }

    @NonNull
    public static <S extends RpcService> S loadService(@NonNull Class<S> type, @NonNull ServiceLoader<S> serviceLoader) {
        Objects.requireNonNull(type, "type must not be null");
        Objects.requireNonNull(serviceLoader, "serviceLoader must not be null");
        Iterator<S> iterator = serviceLoader.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalStateException("No service implementation found for service type '" + String.valueOf(type) + "'");
        }
        RpcService serviceInstance = (RpcService)iterator.next();
        if (iterator.hasNext()) {
            throw new IllegalStateException("Multiple service implementations found for service type '" + String.valueOf(type) + "'");
        }
        return (S)serviceInstance;
    }
}

