/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.streams.ContractBytecode;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import com.hedera.node.app.service.contract.impl.annotations.TransactionScope;
import com.hedera.node.app.service.contract.impl.exec.ActionSidecarContentTracer;
import com.hedera.node.app.service.contract.impl.exec.CallOutcome;
import com.hedera.node.app.service.contract.impl.exec.TransactionProcessor;
import com.hedera.node.app.service.contract.impl.exec.gas.CustomGasCharging;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.tracers.AddOnEvmActionTracer;
import com.hedera.node.app.service.contract.impl.exec.tracers.EvmActionTracer;
import com.hedera.node.app.service.contract.impl.exec.utils.OpsDurationCounter;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmContext;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransaction;
import com.hedera.node.app.service.contract.impl.hevm.HederaEvmTransactionResult;
import com.hedera.node.app.service.contract.impl.hevm.HydratedEthTxData;
import com.hedera.node.app.service.contract.impl.hevm.OpsDurationSchedule;
import com.hedera.node.app.service.contract.impl.infra.HevmTransactionFactory;
import com.hedera.node.app.service.contract.impl.state.HederaEvmAccount;
import com.hedera.node.app.service.contract.impl.state.RootProxyWorldUpdater;
import com.hedera.node.app.spi.throttle.ThrottleAdviser;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.ResourceExhaustedException;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.JumboTransactionsConfig;
import com.hedera.node.config.data.OpsDurationConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.List;
import java.util.Objects;
import java.util.OptionalLong;
import java.util.concurrent.Callable;
import java.util.function.Supplier;
import javax.inject.Inject;
import org.hyperledger.besu.evm.tracing.OperationTracer;

@TransactionScope
public class ContextTransactionProcessor
implements Callable<CallOutcome> {
    private final HandleContext context;
    private final ContractsConfig contractsConfig;
    private final Configuration configuration;
    private final HederaEvmContext hederaEvmContext;
    @Nullable
    private final HydratedEthTxData hydratedEthTxData;
    @Nullable
    private final Supplier<List<OperationTracer>> addOnTracers;
    private final TransactionProcessor processor;
    private final EvmActionTracer evmActionTracer;
    private final RootProxyWorldUpdater rootProxyWorldUpdater;
    private final HevmTransactionFactory hevmTransactionFactory;
    private final CustomGasCharging gasCharging;
    private final ContractMetrics contractMetrics;

    @Inject
    public ContextTransactionProcessor(@Nullable HydratedEthTxData hydratedEthTxData, @NonNull HandleContext context, @NonNull ContractsConfig contractsConfig, @NonNull Configuration configuration, @NonNull HederaEvmContext hederaEvmContext, @Nullable Supplier<List<OperationTracer>> addOnTracers, @NonNull EvmActionTracer evmActionTracer, @NonNull RootProxyWorldUpdater worldUpdater, @NonNull HevmTransactionFactory hevmTransactionFactory, @NonNull TransactionProcessor processor, @NonNull CustomGasCharging customGasCharging, @NonNull ContractMetrics contractMetrics) {
        this.context = Objects.requireNonNull(context);
        this.hydratedEthTxData = hydratedEthTxData;
        this.addOnTracers = addOnTracers;
        this.evmActionTracer = Objects.requireNonNull(evmActionTracer);
        this.processor = Objects.requireNonNull(processor);
        this.rootProxyWorldUpdater = Objects.requireNonNull(worldUpdater);
        this.configuration = Objects.requireNonNull(configuration);
        this.contractsConfig = Objects.requireNonNull(contractsConfig);
        this.hederaEvmContext = Objects.requireNonNull(hederaEvmContext);
        this.hevmTransactionFactory = Objects.requireNonNull(hevmTransactionFactory);
        this.gasCharging = Objects.requireNonNull(customGasCharging);
        this.contractMetrics = Objects.requireNonNull(contractMetrics);
    }

    @Override
    public CallOutcome call() {
        OpsDurationCounter opsDurationCounter;
        boolean opsDurationThrottleEnabled;
        long startTimeNanos = System.nanoTime();
        this.assertEthTxDataValidIfApplicable();
        HederaEvmTransaction hevmTransaction = this.safeCreateHevmTransaction();
        if (hevmTransaction.isException()) {
            CallOutcome outcome = this.maybeChargeFeesAndReturnOutcome(hevmTransaction, this.context.body().transactionIDOrThrow().accountIDOrThrow(), this.rootProxyWorldUpdater.getHederaAccount(hevmTransaction.senderId()), this.contractsConfig.chargeGasOnEvmHandleException());
            long elapsedNanos = System.nanoTime() - startTimeNanos;
            this.recordProcessedTransactionToMetrics(hevmTransaction, outcome, elapsedNanos, 0L);
            return outcome;
        }
        ThrottleAdviser throttleAdviser = this.rootProxyWorldUpdater.enhancement().operations().getThrottleAdviser();
        boolean bl = opsDurationThrottleEnabled = this.contractsConfig.throttleThrottleByOpsDuration() && throttleAdviser != null;
        if (opsDurationThrottleEnabled) {
            boolean hasAnyCapacityLeft;
            boolean bl2 = hasAnyCapacityLeft = throttleAdviser.availableOpsDurationCapacity() > 0L;
            if (!hasAnyCapacityLeft) {
                this.contractMetrics.opsDurationMetrics().recordTransactionThrottledByOpsDuration();
                CallOutcome outcome = this.maybeChargeFeesAndReturnOutcome(hevmTransaction.withException((HandleException)new ResourceExhaustedException(ResponseCodeEnum.CONSENSUS_GAS_EXHAUSTED)), this.context.body().transactionIDOrThrow().accountIDOrThrow(), this.rootProxyWorldUpdater.getHederaAccount(hevmTransaction.senderId()), true);
                long elapsedNanos = System.nanoTime() - startTimeNanos;
                this.recordProcessedTransactionToMetrics(hevmTransaction, outcome, elapsedNanos, 0L);
                return outcome;
            }
            OpsDurationSchedule opsDurationSchedule = OpsDurationSchedule.fromConfig((OpsDurationConfig)this.configuration.getConfigData(OpsDurationConfig.class));
            opsDurationCounter = OpsDurationCounter.withSchedule(opsDurationSchedule);
        } else {
            opsDurationCounter = OpsDurationCounter.disabled();
        }
        try {
            ActionSidecarContentTracer tracer = this.addOnTracers != null ? new AddOnEvmActionTracer(this.evmActionTracer, this.addOnTracers.get()) : this.evmActionTracer;
            HederaEvmTransactionResult result = this.processor.processTransaction(hevmTransaction, this.rootProxyWorldUpdater, this.hederaEvmContext, tracer, this.configuration, opsDurationCounter);
            if (this.hydratedEthTxData != null) {
                HederaEvmAccount sender = Objects.requireNonNull(this.rootProxyWorldUpdater.getHederaAccount(hevmTransaction.senderId()));
                result = result.withSignerNonce(sender.getNonce());
            }
            if (!result.isSuccess() && hevmTransaction.needsInitcodeExternalizedOnFailure()) {
                ContractBytecode contractBytecode = ContractBytecode.newBuilder().initcode(hevmTransaction.payload()).build();
                Objects.requireNonNull(this.hederaEvmContext.streamBuilder()).addContractBytecode(contractBytecode, false);
            }
            Bytes callData = this.hydratedEthTxData != null && this.hydratedEthTxData.ethTxData() != null ? Bytes.wrap((byte[])this.hydratedEthTxData.ethTxData().callData()) : null;
            CallOutcome outcome = CallOutcome.fromResultsWithMaybeSidecars(result.asProtoResultOf(this.ethTxDataIfApplicable(), this.rootProxyWorldUpdater, callData), result.asEvmTxResultOf(this.ethTxDataIfApplicable(), callData), result.isSuccess() ? this.rootProxyWorldUpdater.getUpdatedContractNonces() : null, result.isSuccess() ? this.rootProxyWorldUpdater.getCreatedContractIds() : null, result.isSuccess() ? result.evmAddressIfCreatedIn(this.rootProxyWorldUpdater) : null, result);
            if (opsDurationThrottleEnabled) {
                throttleAdviser.consumeOpsDurationThrottleCapacity(opsDurationCounter.opsDurationUnitsConsumed());
            }
            long elapsedNanos = System.nanoTime() - startTimeNanos;
            this.recordProcessedTransactionToMetrics(hevmTransaction, outcome, elapsedNanos, opsDurationCounter.opsDurationUnitsConsumed());
            return outcome;
        }
        catch (HandleException e) {
            HederaEvmAccount sender = this.rootProxyWorldUpdater.getHederaAccount(hevmTransaction.senderId());
            AccountID senderId = sender != null ? sender.hederaId() : hevmTransaction.senderId();
            CallOutcome outcome = this.maybeChargeFeesAndReturnOutcome(hevmTransaction.withException(e), senderId, sender, hevmTransaction.isContractCall() && this.contractsConfig.chargeGasOnEvmHandleException());
            if (opsDurationThrottleEnabled) {
                throttleAdviser.consumeOpsDurationThrottleCapacity(opsDurationCounter.opsDurationUnitsConsumed());
            }
            long elapsedNanos = System.nanoTime() - startTimeNanos;
            this.recordProcessedTransactionToMetrics(hevmTransaction, outcome, elapsedNanos, opsDurationCounter.opsDurationUnitsConsumed());
            return outcome;
        }
    }

    private void recordProcessedTransactionToMetrics(HederaEvmTransaction hevmTxn, CallOutcome outcome, long elapsedNanos, long opsDurationUnitsConsumed) {
        this.contractMetrics.recordProcessedTransaction(new ContractMetrics.TransactionProcessingSummary(elapsedNanos, opsDurationUnitsConsumed, outcome.result().gasUsed(), hevmTxn.hasOfferedGasPrice() ? OptionalLong.of(hevmTxn.offeredGasPrice()) : OptionalLong.empty(), outcome.isSuccess()));
    }

    private HederaEvmTransaction safeCreateHevmTransaction() {
        try {
            HederaEvmTransaction hevmTransaction = this.hevmTransactionFactory.fromHapiTransaction(this.context.body(), this.context.payer());
            this.validatePayloadLength(hevmTransaction);
            return hevmTransaction;
        }
        catch (HandleException e) {
            return this.hevmTransactionFactory.fromContractTxException(this.context.body(), e);
        }
    }

    private void validatePayloadLength(HederaEvmTransaction hevmTransaction) {
        int maxJumboEthereumCallDataSize = ((JumboTransactionsConfig)this.configuration.getConfigData(JumboTransactionsConfig.class)).ethereumMaxCallDataSize();
        if (hevmTransaction.payload().length() > (long)maxJumboEthereumCallDataSize) {
            throw new HandleException(ResponseCodeEnum.TRANSACTION_OVERSIZE);
        }
    }

    private CallOutcome maybeChargeFeesAndReturnOutcome(@NonNull HederaEvmTransaction hevmTransaction, @NonNull AccountID senderId, @Nullable HederaEvmAccount sender, boolean chargeGas) {
        ResponseCodeEnum status = Objects.requireNonNull(hevmTransaction.exception()).getStatus();
        if (chargeGas) {
            this.gasCharging.chargeGasForAbortedTransaction(senderId, this.hederaEvmContext, this.rootProxyWorldUpdater, hevmTransaction);
        }
        this.rootProxyWorldUpdater.commit();
        ContractID recipientId = null;
        if (!ResponseCodeEnum.INVALID_CONTRACT_ID.equals((Object)status)) {
            recipientId = hevmTransaction.contractId();
        }
        HederaEvmTransactionResult result = HederaEvmTransactionResult.fromAborted(senderId, recipientId, status);
        if (this.context.body().hasEthereumTransaction() && sender != null) {
            result = result.withSignerNonce(sender.getNonce());
        }
        Bytes ethCallData = this.hydratedEthTxData != null && this.hydratedEthTxData.ethTxData() != null ? Bytes.wrap((byte[])this.hydratedEthTxData.ethTxData().callData()) : null;
        return CallOutcome.fromResultsWithoutSidecars(result.asProtoResultOf(this.ethTxDataIfApplicable(), this.rootProxyWorldUpdater, ethCallData), result.asEvmTxResultOf(this.ethTxDataIfApplicable(), ethCallData), null, null, null, result);
    }

    private void assertEthTxDataValidIfApplicable() {
        if (this.hydratedEthTxData != null && !this.hydratedEthTxData.isAvailable()) {
            throw new HandleException(this.hydratedEthTxData.status());
        }
    }

    @Nullable
    private EthTxData ethTxDataIfApplicable() {
        return this.hydratedEthTxData == null ? null : this.hydratedEthTxData.ethTxData();
    }
}

