/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec;

import com.hedera.node.app.service.contract.impl.annotations.TransactionScope;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.StakingConfig;
import com.swirlds.config.api.Configuration;
import dagger.Module;
import dagger.Provides;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

@Module
public interface TransactionConfigModule {
    @Provides
    @TransactionScope
    public static Configuration provideConfiguration(@NonNull HandleContext context) {
        return Objects.requireNonNull(context).configuration();
    }

    @Provides
    @TransactionScope
    public static ContractsConfig provideContractsConfig(@NonNull Configuration configuration) {
        return (ContractsConfig)Objects.requireNonNull(configuration).getConfigData(ContractsConfig.class);
    }

    @Provides
    @TransactionScope
    public static HederaConfig provideHederaConfig(@NonNull Configuration configuration) {
        return (HederaConfig)Objects.requireNonNull(configuration).getConfigData(HederaConfig.class);
    }

    @Provides
    @TransactionScope
    public static LedgerConfig provideLedgerConfig(@NonNull Configuration configuration) {
        return (LedgerConfig)Objects.requireNonNull(configuration).getConfigData(LedgerConfig.class);
    }

    @Provides
    @TransactionScope
    public static StakingConfig provideStakingConfig(@NonNull Configuration configuration) {
        return (StakingConfig)Objects.requireNonNull(configuration).getConfigData(StakingConfig.class);
    }

    @Provides
    @TransactionScope
    public static EntitiesConfig provideEntitiesConfig(@NonNull Configuration configuration) {
        return (EntitiesConfig)Objects.requireNonNull(configuration).getConfigData(EntitiesConfig.class);
    }

    @Provides
    @TransactionScope
    public static AccountsConfig provideAccountsConfig(@NonNull Configuration configuration) {
        return (AccountsConfig)Objects.requireNonNull(configuration).getConfigData(AccountsConfig.class);
    }
}

