/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.hevm;

import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.OpsDurationCounter;
import com.hedera.node.app.service.contract.impl.hevm.OpsDurationSchedule;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Optional;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.EvmSpecVersion;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.internal.OverflowException;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.operation.AddModOperation;
import org.hyperledger.besu.evm.operation.AddOperation;
import org.hyperledger.besu.evm.operation.AndOperation;
import org.hyperledger.besu.evm.operation.ByteOperation;
import org.hyperledger.besu.evm.operation.DivOperation;
import org.hyperledger.besu.evm.operation.DupOperation;
import org.hyperledger.besu.evm.operation.ExpOperation;
import org.hyperledger.besu.evm.operation.GtOperation;
import org.hyperledger.besu.evm.operation.InvalidOperation;
import org.hyperledger.besu.evm.operation.IsZeroOperation;
import org.hyperledger.besu.evm.operation.JumpDestOperation;
import org.hyperledger.besu.evm.operation.JumpOperation;
import org.hyperledger.besu.evm.operation.JumpiOperation;
import org.hyperledger.besu.evm.operation.LtOperation;
import org.hyperledger.besu.evm.operation.ModOperation;
import org.hyperledger.besu.evm.operation.MulModOperation;
import org.hyperledger.besu.evm.operation.MulOperation;
import org.hyperledger.besu.evm.operation.NotOperation;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.operation.OperationRegistry;
import org.hyperledger.besu.evm.operation.OrOperation;
import org.hyperledger.besu.evm.operation.PopOperation;
import org.hyperledger.besu.evm.operation.Push0Operation;
import org.hyperledger.besu.evm.operation.PushOperation;
import org.hyperledger.besu.evm.operation.SDivOperation;
import org.hyperledger.besu.evm.operation.SGtOperation;
import org.hyperledger.besu.evm.operation.SLtOperation;
import org.hyperledger.besu.evm.operation.SModOperation;
import org.hyperledger.besu.evm.operation.SignExtendOperation;
import org.hyperledger.besu.evm.operation.StopOperation;
import org.hyperledger.besu.evm.operation.SubOperation;
import org.hyperledger.besu.evm.operation.SwapOperation;
import org.hyperledger.besu.evm.operation.VirtualOperation;
import org.hyperledger.besu.evm.operation.XorOperation;
import org.hyperledger.besu.evm.tracing.OperationTracer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HederaEVM
extends EVM {
    private static final Logger LOG = LoggerFactory.getLogger(HederaEVM.class);
    private final OperationRegistry operations;
    private final GasCalculator gasCalculator;
    private final Operation endOfScriptStop;
    private final EvmSpecVersion evmSpecVersion;
    private final boolean enableShanghai;

    public HederaEVM(@NonNull OperationRegistry operations, @NonNull GasCalculator gasCalculator, @NonNull EvmConfiguration evmConfiguration, @NonNull EvmSpecVersion evmSpecVersion) {
        super(operations, gasCalculator, evmConfiguration, evmSpecVersion);
        this.operations = operations;
        this.gasCalculator = gasCalculator;
        this.endOfScriptStop = new VirtualOperation((Operation)new StopOperation(gasCalculator));
        this.evmSpecVersion = evmSpecVersion;
        this.enableShanghai = EvmSpecVersion.SHANGHAI.ordinal() <= evmSpecVersion.ordinal();
    }

    public void runToHalt(MessageFrame frame, OperationTracer tracing) {
        this.evmSpecVersion.maybeWarnVersion();
        OperationTracer operationTracer = tracing == OperationTracer.NO_TRACING ? null : tracing;
        byte[] code = frame.getCode().getBytes().toArrayUnsafe();
        Operation[] operationArray = this.operations.getOperations();
        OpsDurationCounter opsDurationCounter = FrameUtils.opsDurationCounter(frame);
        OpsDurationSchedule opsDurationSchedule = opsDurationCounter.schedule();
        long[] opsDurationByOpCode = opsDurationSchedule.opsDurationByOpCode();
        long opsDurationMultiplier = opsDurationSchedule.opsGasBasedDurationMultiplier();
        long opsDurationDenominator = opsDurationSchedule.multipliersDenominator();
        while (frame.getState() == MessageFrame.State.CODE_EXECUTING) {
            Operation.OperationResult result;
            Operation currentOperation;
            int opcode;
            int pc = frame.getPC();
            try {
                opcode = code[pc] & 0xFF;
                currentOperation = operationArray[opcode];
            }
            catch (ArrayIndexOutOfBoundsException var15) {
                opcode = 0;
                currentOperation = this.endOfScriptStop;
            }
            frame.setCurrentOperation(currentOperation);
            if (operationTracer != null) {
                operationTracer.tracePreExecution(frame);
            }
            try {
                result = switch (opcode) {
                    case 0 -> StopOperation.staticOperation((MessageFrame)frame);
                    case 1 -> AddOperation.staticOperation((MessageFrame)frame);
                    case 2 -> MulOperation.staticOperation((MessageFrame)frame);
                    case 3 -> SubOperation.staticOperation((MessageFrame)frame);
                    case 4 -> DivOperation.staticOperation((MessageFrame)frame);
                    case 5 -> SDivOperation.staticOperation((MessageFrame)frame);
                    case 6 -> ModOperation.staticOperation((MessageFrame)frame);
                    case 7 -> SModOperation.staticOperation((MessageFrame)frame);
                    case 8 -> AddModOperation.staticOperation((MessageFrame)frame);
                    case 9 -> MulModOperation.staticOperation((MessageFrame)frame);
                    case 10 -> ExpOperation.staticOperation((MessageFrame)frame, (GasCalculator)this.gasCalculator);
                    case 11 -> SignExtendOperation.staticOperation((MessageFrame)frame);
                    case 12, 13, 14, 15 -> InvalidOperation.INVALID_RESULT;
                    case 16 -> LtOperation.staticOperation((MessageFrame)frame);
                    case 17 -> GtOperation.staticOperation((MessageFrame)frame);
                    case 18 -> SLtOperation.staticOperation((MessageFrame)frame);
                    case 19 -> SGtOperation.staticOperation((MessageFrame)frame);
                    case 21 -> IsZeroOperation.staticOperation((MessageFrame)frame);
                    case 22 -> AndOperation.staticOperation((MessageFrame)frame);
                    case 23 -> OrOperation.staticOperation((MessageFrame)frame);
                    case 24 -> XorOperation.staticOperation((MessageFrame)frame);
                    case 25 -> NotOperation.staticOperation((MessageFrame)frame);
                    case 26 -> ByteOperation.staticOperation((MessageFrame)frame);
                    case 80 -> PopOperation.staticOperation((MessageFrame)frame);
                    case 86 -> JumpOperation.staticOperation((MessageFrame)frame);
                    case 87 -> JumpiOperation.staticOperation((MessageFrame)frame);
                    case 91 -> JumpDestOperation.JUMPDEST_SUCCESS;
                    case 95 -> {
                        if (this.enableShanghai) {
                            yield Push0Operation.staticOperation((MessageFrame)frame);
                        }
                        yield InvalidOperation.INVALID_RESULT;
                    }
                    case 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127 -> PushOperation.staticOperation((MessageFrame)frame, (byte[])code, (int)pc, (int)(opcode - 95));
                    case 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143 -> DupOperation.staticOperation((MessageFrame)frame, (int)(opcode - 127));
                    case 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159 -> SwapOperation.staticOperation((MessageFrame)frame, (int)(opcode - 143));
                    default -> {
                        frame.setCurrentOperation(currentOperation);
                        yield currentOperation.execute(frame, (EVM)this);
                    }
                };
            }
            catch (OverflowException var13) {
                result = OVERFLOW_RESPONSE;
            }
            catch (UnderflowException var14) {
                result = UNDERFLOW_RESPONSE;
            }
            ExceptionalHaltReason haltReason = result.getHaltReason();
            if (haltReason != null) {
                LOG.trace("MessageFrame evaluation halted because of {}", (Object)haltReason);
                frame.setExceptionalHaltReason(Optional.of(haltReason));
                frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
            } else if (frame.decrementRemainingGas(result.getGasCost()) < 0L) {
                frame.setExceptionalHaltReason(Optional.of(ExceptionalHaltReason.INSUFFICIENT_GAS));
                frame.setState(MessageFrame.State.EXCEPTIONAL_HALT);
            } else {
                long opsDurationUnitsCost = opsDurationByOpCode[opcode] == 0L ? result.getGasCost() * opsDurationMultiplier / opsDurationDenominator : opsDurationByOpCode[opcode];
                opsDurationCounter.recordOpsDurationUnitsConsumed(opsDurationUnitsCost);
            }
            if (frame.getState() == MessageFrame.State.CODE_EXECUTING) {
                int currentPC = frame.getPC();
                int opSize = result.getPcIncrement();
                frame.setPC(currentPC + opSize);
            }
            if (operationTracer == null) continue;
            operationTracer.tracePostExecution(frame, result);
        }
    }
}

