/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.handle.steps;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.freeze.FreezeType;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.ids.ReadableEntityIdStoreImpl;
import com.hedera.node.app.service.addressbook.impl.ReadableNodeStoreImpl;
import com.hedera.node.app.service.networkadmin.impl.schemas.V0490FreezeSchema;
import com.hedera.node.app.service.token.impl.ReadableStakingInfoStoreImpl;
import com.hedera.node.app.spi.ids.ReadableEntityCounters;
import com.hedera.node.config.data.NetworkAdminConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.platform.config.AddressBookConfig;
import com.swirlds.platform.state.service.WritablePlatformStateStore;
import com.swirlds.state.State;
import com.swirlds.state.spi.ReadableSingletonState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Instant;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.roster.WritableRosterStore;

@Singleton
public class PlatformStateUpdates {
    private static final Logger logger = LogManager.getLogger(PlatformStateUpdates.class);
    private final BiConsumer<Roster, Path> rosterExportHelper;

    @Inject
    public PlatformStateUpdates(@NonNull BiConsumer<Roster, Path> rosterExportHelper) {
        this.rosterExportHelper = Objects.requireNonNull(rosterExportHelper);
    }

    public void handleTxBody(@NonNull State state, @NonNull TransactionBody txBody, @NonNull Configuration config) {
        Objects.requireNonNull(state, "state must not be null");
        Objects.requireNonNull(txBody, "txBody must not be null");
        Objects.requireNonNull(config, "config must not be null");
        if (txBody.hasFreeze()) {
            FreezeType freezeType = txBody.freezeOrThrow().freezeType();
            WritablePlatformStateStore platformStateStore = new WritablePlatformStateStore(state.getWritableStates("PlatformStateService"));
            switch (freezeType) {
                case UNKNOWN_FREEZE_TYPE: 
                case TELEMETRY_UPGRADE: {
                    break;
                }
                case FREEZE_UPGRADE: 
                case FREEZE_ONLY: {
                    logger.info("Transaction freeze of type {} detected", (Object)freezeType);
                    ReadableStates states = state.getReadableStates("FreezeService");
                    ReadableSingletonState freezeTimeState = states.getSingleton(V0490FreezeSchema.FREEZE_TIME_STATE_ID);
                    Timestamp freezeTime = Objects.requireNonNull((Timestamp)freezeTimeState.get());
                    Instant freezeTimeInstant = Instant.ofEpochSecond(freezeTime.seconds(), freezeTime.nanos());
                    logger.info("Freeze time will be {}", (Object)freezeTimeInstant);
                    platformStateStore.setFreezeTime(freezeTimeInstant);
                    break;
                }
                case FREEZE_ABORT: {
                    logger.info("Aborting freeze");
                    platformStateStore.setFreezeTime(null);
                    break;
                }
                case PREPARE_UPGRADE: {
                    NetworkAdminConfig networkAdminConfig = (NetworkAdminConfig)config.getConfigData(NetworkAdminConfig.class);
                    AddressBookConfig addressBookConfig = (AddressBookConfig)config.getConfigData(AddressBookConfig.class);
                    ReadableEntityIdStoreImpl entityIdStore = new ReadableEntityIdStoreImpl(state.getReadableStates("EntityIdService"));
                    if (!addressBookConfig.createCandidateRosterOnPrepareUpgrade()) break;
                    ReadableNodeStoreImpl nodeStore = new ReadableNodeStoreImpl(state.getReadableStates("AddressBookService"), (ReadableEntityCounters)entityIdStore);
                    WritableRosterStore rosterStore = new WritableRosterStore(state.getWritableStates("RosterService"));
                    ReadableEntityIdStoreImpl entityCounters = new ReadableEntityIdStoreImpl(state.getReadableStates("EntityIdService"));
                    ReadableStakingInfoStoreImpl stakingInfoStore = new ReadableStakingInfoStoreImpl(state.getReadableStates("TokenService"), (ReadableEntityCounters)entityCounters);
                    Roster candidateRoster = nodeStore.snapshotOfFutureRoster(stakingInfoStore.weightFunction());
                    if (this.hasZeroWeight(candidateRoster)) {
                        candidateRoster = this.assignWeights(candidateRoster, Objects.requireNonNull(rosterStore.getActiveRoster()));
                    }
                    logger.info("Candidate roster with updated weights is {}", (Object)candidateRoster);
                    boolean rosterAccepted = false;
                    try {
                        rosterStore.putCandidateRoster(candidateRoster);
                        rosterAccepted = true;
                    }
                    catch (Exception e) {
                        logger.warn("Candidate roster was rejected", (Throwable)e);
                    }
                    if (!rosterAccepted || !networkAdminConfig.exportCandidateRoster()) break;
                    this.doExport(candidateRoster, networkAdminConfig);
                }
            }
        }
    }

    private Roster assignWeights(@NonNull Roster to, @NonNull Roster from) {
        Map<Long, Long> fromWeights = from.rosterEntries().stream().collect(Collectors.toMap(RosterEntry::nodeId, RosterEntry::weight));
        return new Roster(to.rosterEntries().stream().map(entry -> entry.copyBuilder().weight(fromWeights.getOrDefault(entry.nodeId(), 0L).longValue()).build()).toList());
    }

    private boolean hasZeroWeight(@NonNull Roster roster) {
        return roster.rosterEntries().stream().mapToLong(RosterEntry::weight).sum() == 0L;
    }

    private void doExport(@NonNull Roster candidateRoster, @NonNull NetworkAdminConfig networkAdminConfig) {
        Path exportPath = Paths.get(networkAdminConfig.candidateRosterExportFile(), new String[0]);
        logger.info("Exporting candidate roster after PREPARE_UPGRADE to '{}'", (Object)exportPath.toAbsolutePath());
        this.rosterExportHelper.accept(candidateRoster, exportPath);
    }
}

