/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.apache.tuweni.bytes.DelegatingBytes32;
import org.hyperledger.besu.ethereum.rlp.RLP;

public class Hash
extends DelegatingBytes32 {
    public static final Hash ZERO = new Hash(Bytes32.ZERO);
    public static final Hash EMPTY_TRIE_HASH = Hash.hash(RLP.NULL);
    public static final Hash EMPTY_LIST_HASH = Hash.hash(RLP.EMPTY_LIST);
    public static final Hash EMPTY = Hash.hash(Bytes.EMPTY);

    protected Hash(Bytes32 bytes) {
        super((Bytes)bytes);
    }

    public static Hash hash(Bytes value) {
        return new Hash(org.hyperledger.besu.crypto.Hash.keccak256((Bytes)value));
    }

    public static Hash wrap(Bytes32 bytes) {
        if (bytes instanceof Hash) {
            return (Hash)bytes;
        }
        return new Hash(bytes);
    }

    @JsonCreator
    public static Hash fromHexString(String str) {
        return new Hash(Bytes32.fromHexStringStrict((CharSequence)str));
    }

    public static Hash fromHexStringLenient(String str) {
        return new Hash(Bytes32.fromHexStringLenient((CharSequence)str));
    }
}

