/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.http;

import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.format.SignStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalField;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

final class DateTimeHelper {
    static final DateTimeFormatter RFC_850_DATE_TIME;
    static final DateTimeFormatter ASCTIME_DATE_TIME;
    private static volatile ZonedDateTime time;
    private static volatile String rfc1123String;
    private static volatile byte[] http1valueBytes;

    private DateTimeHelper() {
    }

    static ZonedDateTime parse(String text) {
        try {
            return ZonedDateTime.parse(text, DateTimeFormatter.RFC_1123_DATE_TIME);
        }
        catch (DateTimeParseException pe) {
            try {
                return ZonedDateTime.parse(text, RFC_850_DATE_TIME);
            }
            catch (DateTimeParseException pe2) {
                return ZonedDateTime.parse(text, ASCTIME_DATE_TIME);
            }
        }
    }

    static ZonedDateTime timestamp() {
        return time;
    }

    static String rfc1123String() {
        return rfc1123String;
    }

    static byte[] http1Bytes() {
        return http1valueBytes;
    }

    static void update() {
        time = ZonedDateTime.now();
        rfc1123String = time.format(DateTimeFormatter.RFC_1123_DATE_TIME);
        http1valueBytes = (rfc1123String + "\r\n").getBytes(StandardCharsets.US_ASCII);
    }

    static {
        Map<Long, String> monthName3d = Map.ofEntries(Map.entry(1L, "Jan"), Map.entry(2L, "Feb"), Map.entry(3L, "Mar"), Map.entry(4L, "Apr"), Map.entry(5L, "May"), Map.entry(6L, "Jun"), Map.entry(7L, "Jul"), Map.entry(8L, "Aug"), Map.entry(9L, "Sep"), Map.entry(10L, "Oct"), Map.entry(11L, "Nov"), Map.entry(12L, "Dec"));
        Map<Long, String> dayOfWeekFull = Map.of(1L, "Monday", 2L, "Tuesday", 3L, "Wednesday", 4L, "Thursday", 5L, "Friday", 6L, "Saturday", 7L, "Sunday");
        RFC_850_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, dayOfWeekFull).appendLiteral(", ").optionalEnd().appendValue(ChronoField.DAY_OF_MONTH, 2, 2, SignStyle.NOT_NEGATIVE).appendLiteral('-').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, monthName3d).appendLiteral('-').appendValueReduced((TemporalField)ChronoField.YEAR, 2, 2, LocalDate.now().minusYears(50L).getYear()).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).optionalStart().appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).optionalEnd().appendLiteral(' ').appendOffset("+HHMM", "GMT").toFormatter();
        Map<Long, String> dayOfWeek3d = Map.of(1L, "Mon", 2L, "Tue", 3L, "Wed", 4L, "Thu", 5L, "Fri", 6L, "Sat", 7L, "Sun");
        ASCTIME_DATE_TIME = new DateTimeFormatterBuilder().parseCaseInsensitive().parseLenient().optionalStart().appendText((TemporalField)ChronoField.DAY_OF_WEEK, dayOfWeek3d).appendLiteral(' ').appendText((TemporalField)ChronoField.MONTH_OF_YEAR, monthName3d).appendLiteral(' ').padNext(2).appendValue(ChronoField.DAY_OF_MONTH, 1, 2, SignStyle.NOT_NEGATIVE).appendLiteral(' ').appendValue(ChronoField.HOUR_OF_DAY, 2).appendLiteral(':').appendValue(ChronoField.MINUTE_OF_HOUR, 2).appendLiteral(':').appendValue(ChronoField.SECOND_OF_MINUTE, 2).appendLiteral(' ').appendValue(ChronoField.YEAR, 4).parseDefaulting(ChronoField.OFFSET_SECONDS, 0L).toFormatter();
        DateTimeHelper.update();
        new Timer("helidon-http-timer", true).schedule(new TimerTask(){

            @Override
            public void run() {
                DateTimeHelper.update();
            }
        }, 1000L, 1000L);
    }
}

