/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.http.Method;
import io.helidon.http.PathMatcher;
import io.helidon.http.PathMatchers;
import io.helidon.webserver.http.Handler;
import io.helidon.webserver.http.HttpRoute;
import io.helidon.webserver.http.HttpService;
import io.helidon.webserver.http.ServerRequest;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface HttpRules {
    public HttpRules register(HttpService ... var1);

    default public HttpRules register(Supplier<? extends HttpService> service) {
        return this.register(service.get());
    }

    default public HttpRules register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2) {
        return this.register(service1.get(), service2.get());
    }

    default public HttpRules register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3) {
        return this.register(service1.get(), service2.get(), service3.get());
    }

    default public HttpRules register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4) {
        return this.register(service1.get(), service2.get(), service3.get(), service4.get());
    }

    default public HttpRules register(Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4, Supplier<? extends HttpService> service5) {
        return this.register(service1.get(), service2.get(), service3.get(), service4.get(), service5.get());
    }

    default public HttpRules register(List<Supplier<? extends HttpService>> services) {
        return this.register((HttpService[])services.stream().map(Supplier::get).toArray(HttpService[]::new));
    }

    public HttpRules register(String var1, HttpService ... var2);

    default public HttpRules register(String pathPattern, Supplier<? extends HttpService> service) {
        return this.register(pathPattern, service.get());
    }

    default public HttpRules register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2) {
        return this.register(pathPattern, service1.get(), service2.get());
    }

    default public HttpRules register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3) {
        return this.register(pathPattern, service1.get(), service2.get(), service3.get());
    }

    default public HttpRules register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4) {
        return this.register(pathPattern, service1.get(), service2.get(), service3.get(), service4.get());
    }

    default public HttpRules register(String pathPattern, Supplier<? extends HttpService> service1, Supplier<? extends HttpService> service2, Supplier<? extends HttpService> service3, Supplier<? extends HttpService> service4, Supplier<? extends HttpService> service5) {
        return this.register(pathPattern, service1.get(), service2.get(), service3.get(), service4.get(), service5.get());
    }

    default public HttpRules register(String pathPattern, List<Supplier<? extends HttpService>> services) {
        return this.register(pathPattern, (HttpService[])services.stream().map(Supplier::get).toArray(HttpService[]::new));
    }

    public HttpRules route(HttpRoute var1);

    default public HttpRules route(Supplier<? extends HttpRoute> route) {
        return this.route(route.get());
    }

    default public HttpRules route(Method method, String pathPattern, Handler handler) {
        return this.route((Predicate<Method>)Method.predicate((Method[])new Method[]{method}), PathMatchers.create((String)pathPattern), handler);
    }

    default public HttpRules route(Method method, PathMatcher pathMatcher, Handler handler) {
        return this.route((Predicate<Method>)Method.predicate((Method[])new Method[]{method}), pathMatcher, handler);
    }

    default public HttpRules route(Predicate<Method> methodPredicate, PathMatcher pathMatcher, Handler handler) {
        return this.route(HttpRoute.builder().methods(methodPredicate).path(pathMatcher).handler(handler).build());
    }

    default public HttpRules route(Method method, Handler handler) {
        return this.route(HttpRoute.builder().methods(method).handler(handler).build());
    }

    default public HttpRules get(String pathPattern, Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.GET, pathPattern, handler);
        }
        return this;
    }

    default public HttpRules get(Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.GET, handler);
        }
        return this;
    }

    default public HttpRules post(String pathPattern, Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.POST, pathPattern, handler);
        }
        return this;
    }

    default public HttpRules post(Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.POST, handler);
        }
        return this;
    }

    default public HttpRules put(String pathPattern, Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.PUT, pathPattern, handler);
        }
        return this;
    }

    default public HttpRules put(Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.PUT, handler);
        }
        return this;
    }

    default public HttpRules delete(String pathPattern, Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.DELETE, pathPattern, handler);
        }
        return this;
    }

    default public HttpRules delete(Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.DELETE, handler);
        }
        return this;
    }

    default public HttpRules head(String pathPattern, Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.HEAD, pathPattern, handler);
        }
        return this;
    }

    default public HttpRules head(Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.HEAD, handler);
        }
        return this;
    }

    default public HttpRules options(String pathPattern, Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.OPTIONS, pathPattern, handler);
        }
        return this;
    }

    default public HttpRules options(Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.OPTIONS, handler);
        }
        return this;
    }

    default public HttpRules trace(String pathPattern, Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.TRACE, pathPattern, handler);
        }
        return this;
    }

    default public HttpRules trace(Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.TRACE, handler);
        }
        return this;
    }

    default public HttpRules patch(String pathPattern, Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.PATCH, pathPattern, handler);
        }
        return this;
    }

    default public HttpRules patch(Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route(Method.PATCH, handler);
        }
        return this;
    }

    default public HttpRules any(String pathPattern, Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route((Supplier<? extends HttpRoute>)((Object)HttpRoute.builder().path(pathPattern).handler(handler)));
        }
        return this;
    }

    default public HttpRules any(Handler ... handlers) {
        for (Handler handler : handlers) {
            this.route((Supplier<? extends HttpRoute>)((Object)HttpRoute.builder().handler(handler)));
        }
        return this;
    }

    default public HttpRules route(Method method, String pathPattern, Consumer<ServerRequest> handler) {
        return this.route((Supplier<? extends HttpRoute>)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(Handler.create(handler))));
    }

    default public HttpRules route(Method method, String pathPattern, Function<ServerRequest, ?> handler) {
        return this.route((Supplier<? extends HttpRoute>)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(Handler.create(handler))));
    }

    default public HttpRules route(Method method, String pathPattern, Supplier<?> handler) {
        return this.route((Supplier<? extends HttpRoute>)((Object)HttpRoute.builder().methods(method).path(pathPattern).handler(Handler.create(handler))));
    }
}

